/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWireLargeMessageTest
extends BasicOpenWireTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public SimpleString lmAddress = SimpleString.of((String)"LargeMessageAddress");
    public SimpleString lmDropAddress = SimpleString.of((String)"LargeMessageDropAddress");

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.realStore = true;
        super.setUp();
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.lmAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.lmDropAddress).setRoutingType(RoutingType.ANYCAST));
    }

    @Override
    protected void configureAddressSettings(Map<String, AddressSettings> addressSettingsMap) {
        addressSettingsMap.put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")).setAutoCreateAddresses(Boolean.valueOf(true)));
        addressSettingsMap.put(this.lmDropAddress.toString(), new AddressSettings().setMaxSizeBytes(102400L).setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP).setMaxSizeMessages(2L).setMessageCounterHistoryDayLimit(10).setRedeliveryDelay(0L).setMaxDeliveryAttempts(0));
    }

    @Test
    public void testSendReceiveLargeMessageRestart() throws Exception {
        this.internalSendReceiveLargeMessage((ConnectionFactory)this.factory, true);
        this.internalSendReceiveLargeMessage(CFUtil.createConnectionFactory("openwire", "tcp://localhost:61618"), true);
    }

    @Test
    public void testSendReceiveLargeMessage() throws Exception {
        this.internalSendReceiveLargeMessage((ConnectionFactory)this.factory, false);
        this.internalSendReceiveLargeMessage(CFUtil.createConnectionFactory("openwire", "tcp://localhost:61618"), false);
    }

    private void internalSendReceiveLargeMessage(ConnectionFactory factory, boolean restart) throws Exception {
        Queue queue;
        Session session;
        String randomString = "This is a random String " + RandomUtil.randomString();
        StringBuffer largeBuffer = new StringBuffer();
        while (largeBuffer.length() < 0x100000) {
            largeBuffer.append(randomString);
        }
        String largeString = largeBuffer.toString();
        try (Connection connection = factory.createConnection();){
            connection.start();
            session = connection.createSession(false, 1);
            queue = session.createQueue(this.lmAddress.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            TextMessage message = session.createTextMessage(largeString);
            producer.send((Message)message);
        }
        if (restart) {
            this.server.stop();
            this.server.start();
        }
        connection = factory.createConnection();
        try {
            connection.start();
            session = connection.createSession(false, 1);
            queue = session.createQueue(this.lmAddress.toString());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            TextMessage m = (TextMessage)consumer.receive(5000L);
            Assertions.assertEquals((Object)largeString, (Object)m.getText());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testFastLargeMessageProducerDropOnPaging() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler(true);){
            int size = 204800;
            byte[] bytes = new byte[size];
            try (Connection connection = this.factory.createConnection();){
                connection.start();
                try (Session session = connection.createSession(false, 1);){
                    Queue queue = session.createQueue(this.lmDropAddress.toString());
                    try (MessageProducer producer = session.createProducer((Destination)queue);){
                        producer.setDeliveryMode(1);
                        bytes[0] = 1;
                        BytesMessage message = session.createBytesMessage();
                        message.writeBytes(bytes);
                        PagingStore pageStore = this.server.getPagingManager().getPageStore(this.lmDropAddress);
                        while (!pageStore.isPaging()) {
                            producer.send((Message)message);
                        }
                        for (int i = 0; i < 10; ++i) {
                            producer.send((Message)message);
                        }
                        long messageCount = this.server.locateQueue(this.lmDropAddress).getMessageCount();
                        Assertions.assertTrue((messageCount > 0L ? (byte)1 : 0) != 0, (String)"The queue cannot be empty");
                        try (MessageConsumer messageConsumer = session.createConsumer((Destination)queue);){
                            for (long m = 0L; m < messageCount; ++m) {
                                if (messageConsumer.receive(2000L) != null) continue;
                                Assertions.fail((String)"The messages are not finished yet");
                            }
                        }
                    }
                }
            }
            this.server.stop();
            Assertions.assertFalse((boolean)loggerHandler.findTrace("NullPointerException"));
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"It was not possible to delete message"}));
        }
    }

    @Test
    public void testSendReceiveLargeMessageTX() throws Exception {
        int NUMBER_OF_MESSAGES = 1000;
        int TX_SIZE = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        this.runAfter(executorService::shutdownNow);
        AtomicInteger errors = new AtomicInteger(0);
        CountDownLatch latch = new CountDownLatch(1);
        String randomString = "This is a random String " + RandomUtil.randomString();
        StringBuffer largeBuffer = new StringBuffer();
        while (largeBuffer.length() < 0x100000) {
            largeBuffer.append(randomString);
        }
        String largeString = largeBuffer.toString();
        executorService.execute(() -> {
            try (Connection connection = this.factory.createConnection();){
                connection.start();
                Session session = connection.createSession(true, 0);
                Queue queue = session.createQueue(this.lmAddress.toString());
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                for (int received = 0; received < NUMBER_OF_MESSAGES; ++received) {
                    Message m = consumer.receive(5000L);
                    Assertions.assertNotNull((Object)m);
                    if (m instanceof TextMessage) {
                        Assertions.assertEquals((Object)largeString, (Object)((TextMessage)m).getText());
                    }
                    if (received <= 0 || received % TX_SIZE != 0) continue;
                    logger.info("Received {} messages", (Object)received);
                    session.commit();
                }
                session.commit();
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                errors.incrementAndGet();
            }
            finally {
                latch.countDown();
            }
        });
        try (Connection connection = this.factory.createConnection();){
            connection.start();
            Session session = connection.createSession(true, 0);
            Queue queue = session.createQueue(this.lmAddress.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            for (int sent = 0; sent < NUMBER_OF_MESSAGES; ++sent) {
                TextMessage message;
                if (sent % 2 == 0) {
                    message = session.createTextMessage(largeString);
                } else {
                    BytesMessage bytesMessage = session.createBytesMessage();
                    bytesMessage.writeBytes(largeString.getBytes(StandardCharsets.UTF_8));
                    message = bytesMessage;
                }
                producer.send((Message)message);
                if (sent <= 0 || sent % TX_SIZE != 0) continue;
                logger.info("Sent {} messages", (Object)sent);
                session.commit();
            }
            session.commit();
        }
        latch.await(1L, TimeUnit.MINUTES);
        Assertions.assertEquals((int)0, (int)errors.get());
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        try {
            serverConfig.addAcceptorConfiguration("openwire", "tcp://0.0.0.0:61618?OPENWIRE;openwireMaxPacketSize=10 * 1024");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

