/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JmsAutoAckListenerTest
extends BasicOpenWireTest
implements MessageListener {
    private final CountDownLatch latch = new CountDownLatch(1);

    @Test
    public void testAckedMessageAreConsumed() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(this.queueName);
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        consumer.setMessageListener((MessageListener)this);
        this.latch.await(10L, TimeUnit.SECONDS);
        session = this.connection.createSession(false, 1);
        consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        Assertions.assertNull((Object)msg);
        session.close();
    }

    public void onMessage(Message message) {
        Assertions.assertNotNull((Object)message);
        this.latch.countDown();
    }
}

