/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.metrics.plugins.SimpleMetricsPlugin;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class MetricsPluginTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean legacyConfig;
    protected ActiveMQServer server;
    protected ClientSession session;
    protected ClientSessionFactory sf;
    protected ServerLocator locator;

    @Parameters(name="legacyConfig={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    public MetricsPluginTest(boolean legacyConfig) {
        this.legacyConfig = legacyConfig;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig());
        if (this.legacyConfig) {
            this.server.getConfiguration().setMetricsPlugin(new SimpleMetricsPlugin().init(null));
        } else {
            this.server.getConfiguration().setMetricsConfiguration(new MetricsConfiguration().setPlugin(new SimpleMetricsPlugin().init(null)));
        }
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }

    @TestTemplate
    public void testForArtemisMetricsPresence() throws Exception {
        class Metric {
            public final String name;
            public final Double value;
            public final List<Tag> tags;

            private Metric(String name, Double value) {
                this(name, value, Collections.EMPTY_LIST);
            }

            private Metric(String name, Double value, List<Tag> tags) {
                this.name = name;
                this.value = value;
                this.tags = tags;
            }

            public String toString() {
                return this.name + ": " + this.value + ": " + this.tags;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Metric metric = (Metric)o;
                return Objects.equals(this.name, metric.name) && Objects.equals(this.value, metric.value) && Objects.equals(this.tags, metric.tags);
            }

            public int hashCode() {
                return Objects.hash(this.name, this.value, this.tags);
            }
        }
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        this.session.createQueue(QueueConfiguration.of((String)"simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        Map<Meter.Id, Double> metrics = this.getMetrics();
        List artemisMetrics = metrics.entrySet().stream().map(entry -> new Metric(((Meter.Id)entry.getKey()).getName(), (Double)entry.getValue(), ((Meter.Id)entry.getKey()).getTags())).filter(metric -> metric.name.startsWith("artemis")).collect(Collectors.toList());
        MatcherAssert.assertThat(artemisMetrics, (Matcher)Matchers.containsInAnyOrder((Object[])new Metric[]{new Metric("artemis.address.memory.usage", 0.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.address.memory.usage.percentage", 0.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.connection.count", 1.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.total.connection.count", 1.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.active", 1.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.replica.sync", 0.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.disk.store.usage", 0.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.authentication.count", 0.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"result", (String)"success"))), new Metric("artemis.authentication.count", 0.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"result", (String)"failure"))), new Metric("artemis.authorization.count", 0.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"result", (String)"success"))), new Metric("artemis.authorization.count", 0.0, Arrays.asList(Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"result", (String)"failure"))), new Metric("artemis.message.count", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.durable.message.count", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.persistent.size", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.durable.persistent.size", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.delivering.message.count", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.delivering.durable.message.count", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.delivering.persistent_size", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.delivering.durable.persistent.size", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.scheduled.message.count", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.scheduled.durable.message.count", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.scheduled.persistent.size", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.scheduled.durable.persistent.size", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.messages.acknowledged", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.messages.added", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.messages.killed", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.messages.expired", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.consumer.count", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"), Tag.of((String)"queue", (String)"simpleQueue"))), new Metric("artemis.routed.message.count", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.unrouted.message.count", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.address.size", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.number.of.pages", 0.0, Arrays.asList(Tag.of((String)"address", (String)"simpleAddress"), Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.routed.message.count", 0.0, Arrays.asList(Tag.of((String)"address", (String)"activemq.notifications"), Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.unrouted.message.count", 2.0, Arrays.asList(Tag.of((String)"address", (String)"activemq.notifications"), Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.address.size", 0.0, Arrays.asList(Tag.of((String)"address", (String)"activemq.notifications"), Tag.of((String)"broker", (String)"localhost"))), new Metric("artemis.number.of.pages", 0.0, Arrays.asList(Tag.of((String)"address", (String)"activemq.notifications"), Tag.of((String)"broker", (String)"localhost")))}));
    }

    @TestTemplate
    public void testForBasicMetricsPresenceAndValue() throws Exception {
        this.internalTestForBasicMetrics(true);
    }

    @TestTemplate
    public void testDisablingMetrics() throws Exception {
        this.internalTestForBasicMetrics(false);
    }

    private void internalTestForBasicMetrics(boolean enabled) throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("simpleAddress")).setEnableMetrics(enabled);
        this.session.createQueue(QueueConfiguration.of((String)"simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer("simpleAddress");
        ClientMessage message = this.session.createMessage(true);
        message.getBodyBuffer().writeString(data);
        producer.send((Message)message);
        producer.close();
        Queue queue = this.server.locateQueue("simpleQueue");
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        Map<Meter.Id, Double> metrics = this.getMetrics();
        this.checkMetric(metrics, "artemis.message.count", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.messages.added", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.messages.acknowledged", "queue", "simpleQueue", 0.0, enabled);
        this.checkMetric(metrics, "artemis.durable.message.count", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.delivering.message.count", "queue", "simpleQueue", 0.0, enabled);
        this.checkMetric(metrics, "artemis.routed.message.count", "address", "simpleAddress", 1.0, enabled);
        this.checkMetric(metrics, "artemis.unrouted.message.count", "address", "simpleAddress", 0.0, enabled);
        this.checkMetric(metrics, "artemis.consumer.count", "queue", "simpleQueue", 0.0, enabled);
        ClientConsumer consumer = this.session.createConsumer("simpleQueue");
        this.session.start();
        message = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        metrics = this.getMetrics();
        this.checkMetric(metrics, "artemis.delivering.message.count", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.consumer.count", "queue", "simpleQueue", 1.0, enabled);
        message.acknowledge();
        Assertions.assertEquals((Object)data, (Object)message.getBodyBuffer().readString());
        this.session.commit();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(SimpleString.of((String)"simpleQueue")).getMessagesAcknowledged() == 1L, (long)1000L, (long)100L));
        consumer.close();
        metrics = this.getMetrics();
        this.checkMetric(metrics, "artemis.message.count", "queue", "simpleQueue", 0.0, enabled);
        this.checkMetric(metrics, "artemis.messages.added", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.messages.acknowledged", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.durable.message.count", "queue", "simpleQueue", 0.0, enabled);
        this.checkMetric(metrics, "artemis.delivering.message.count", "queue", "simpleQueue", 0.0, enabled);
        this.checkMetric(metrics, "artemis.routed.message.count", "address", "simpleAddress", 1.0, enabled);
        this.checkMetric(metrics, "artemis.unrouted.message.count", "address", "simpleAddress", 0.0, enabled);
        this.checkMetric(metrics, "artemis.consumer.count", "queue", "simpleQueue", 0.0, enabled);
    }

    @TestTemplate
    public void testMessageCountWithPaging() throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("simpleAddress")).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setMaxSizeBytes(10240L).setPageSizeBytes(5120);
        this.session.createQueue(QueueConfiguration.of((String)"simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer("simpleAddress");
        ClientMessage message = this.session.createMessage(true);
        message.getBodyBuffer().writeString(data);
        long messageCount = 0L;
        while (!this.server.getPagingManager().getPageStore(SimpleString.of((String)"simpleAddress")).isPaging()) {
            producer.send((Message)message);
            ++messageCount;
        }
        Wait.assertEquals((Long)messageCount, () -> ((Queue)this.server.locateQueue("simpleQueue")).getMessageCount(), (long)2000L, (long)100L);
        this.checkMetric(this.getMetrics(), "artemis.message.count", "queue", "simpleQueue", Double.valueOf(messageCount));
        int i = 0;
        while ((long)i < messageCount) {
            producer.send((Message)message);
            ++i;
        }
        producer.close();
        Wait.assertEquals((Long)(messageCount * 2L), () -> ((Queue)this.server.locateQueue("simpleQueue")).getMessageCount(), (long)2000L, (long)100L);
        this.checkMetric(this.getMetrics(), "artemis.message.count", "queue", "simpleQueue", Double.valueOf(messageCount * 2L));
    }

    @TestTemplate
    public void testMetricsPluginRegistration() {
        Assertions.assertEquals(SimpleMetricsPlugin.class, this.server.getConfiguration().getMetricsConfiguration().getPlugin().getClass());
        Assertions.assertEquals((Object)this.server, (Object)((SimpleMetricsPlugin)this.server.getConfiguration().getMetricsConfiguration().getPlugin()).getServer());
    }

    public Map<Meter.Id, Double> getMetrics() {
        return MetricsPluginTest.getMetrics(this.server);
    }

    public static Map<Meter.Id, Double> getMetrics(ActiveMQServer server) {
        HashMap<Meter.Id, Double> metrics = new HashMap<Meter.Id, Double>();
        List meters = server.getMetricsManager().getMeterRegistry().getMeters();
        Assertions.assertTrue((meters.size() > 0 ? (byte)1 : 0) != 0);
        for (Meter meter : meters) {
            Iterable measurements = meter.measure();
            for (Measurement measurement : measurements) {
                metrics.put(meter.getId(), measurement.getValue());
            }
        }
        return metrics;
    }

    public void checkMetric(Map<Meter.Id, Double> metrics, String metric, String tag, String tagValue, Double expectedValue) {
        this.checkMetric(metrics, metric, tag, tagValue, expectedValue, true);
    }

    public void checkMetric(Map<Meter.Id, Double> metrics, String metric, String tag, String tagValue, Double expectedValue, boolean enabled) {
        OptionalDouble actualValue = metrics.entrySet().stream().filter(entry -> metric.equals(((Meter.Id)entry.getKey()).getName())).filter(entry -> tagValue.equals(((Meter.Id)entry.getKey()).getTag(tag))).mapToDouble(Map.Entry::getValue).findFirst();
        if (enabled) {
            Assertions.assertTrue((boolean)actualValue.isPresent(), (String)(metric + " for " + tag + " " + tagValue + " not present"));
            Assertions.assertEquals((double)expectedValue, (double)actualValue.getAsDouble(), (double)0.0, (String)(metric + " not equal"));
        } else {
            Assertions.assertFalse((boolean)actualValue.isPresent(), (String)(metric + " for " + tag + " " + tagValue + " present"));
        }
    }
}

