/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.QueueConnection;
import jakarta.jms.Session;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnection;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivation;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRAClusteredTestBase;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActiveMQClusteredTest
extends ActiveMQRAClusteredTestBase {
    @Test
    public void testShutdownOnPartialConnect() throws Exception {
        ((AddressSettings)this.secondaryServer.getAddressSettingsRepository().getMatch("mdbQueue")).setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false));
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.setHA(Boolean.valueOf(true));
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setSetupAttempts(Integer.valueOf(0));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setHA(Boolean.valueOf(true));
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY + "," + INVM_CONNECTOR_FACTORY);
        qResourceAdapter.setConnectionParameters("server-id=0, server-id=1");
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Assertions.assertEquals((int)((Queue)this.server.getPostOffice().getBinding(MDBQUEUEPREFIXEDSIMPLE).getBindable()).getConsumerCount(), (int)0);
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testNonDurableInCluster() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("mdbTopic");
        spec.setSetupAttempts(Integer.valueOf(5));
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.addClientSession(this.locator.createSessionFactory().createSession());
        ClientProducer clientProducer = session.createProducer("mdbTopic");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("test");
        clientProducer.send((Message)message);
        ActiveMQActivation activation = this.lookupActivation(qResourceAdapter);
        SimpleString tempQueue = activation.getTopicTemporaryQueue();
        Assertions.assertNotNull((Object)this.server.locateQueue(tempQueue));
        Assertions.assertNotNull((Object)this.secondaryServer.locateQueue(tempQueue));
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"test");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
        Assertions.assertNull((Object)this.server.locateQueue(tempQueue));
        Assertions.assertNull((Object)this.secondaryServer.locateQueue(tempQueue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOutboundLoadBalancing() throws Exception {
        int CONNECTION_COUNT = 100;
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ArrayList<Session> sessions = new ArrayList<Session>();
        ArrayList<ActiveMQRAManagedConnection> managedConnections = new ArrayList<ActiveMQRAManagedConnection>();
        try {
            ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
            qResourceAdapter.start((BootstrapContext)ctx);
            ActiveMQRAConnectionManager qraConnectionManager = new ActiveMQRAConnectionManager();
            ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
            mcf.setResourceAdapter((ResourceAdapter)qResourceAdapter);
            ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)qraConnectionManager);
            QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
            Session s = queueConnection.createSession(false, 1);
            sessions.add(s);
            ActiveMQRAManagedConnection mc = (ActiveMQRAManagedConnection)((ActiveMQRASession)s).getManagedConnection();
            managedConnections.add(mc);
            ActiveMQConnectionFactory cf1 = mc.getConnectionFactory();
            while (!((ServerLocatorImpl)cf1.getServerLocator()).isReceivedTopology()) {
                Thread.sleep(50L);
            }
            for (int i = 0; i < 100; ++i) {
                queueConnection = qraConnectionFactory.createQueueConnection();
                s = queueConnection.createSession(false, 1);
                sessions.add(s);
                mc = (ActiveMQRAManagedConnection)((ActiveMQRASession)s).getManagedConnection();
                managedConnections.add(mc);
            }
            Assertions.assertTrue((this.server.getConnectionCount() >= 50 ? (byte)1 : 0) != 0);
            Assertions.assertTrue((this.secondaryServer.getConnectionCount() >= 50 ? (byte)1 : 0) != 0);
        }
        finally {
            for (Session s : sessions) {
                s.close();
            }
            for (ActiveMQRAManagedConnection mc : managedConnections) {
                mc.destroy();
            }
        }
    }

    @Test
    public void testRebalanceWithInfiniteReconnect() throws Exception {
        this.testRebalanceInternal(-1);
    }

    @Test
    public void testRebalanceWithNoReconnect() throws Exception {
        this.testRebalanceInternal(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRebalanceInternal(int reconnectAttempts) throws Exception {
        int CONSUMER_COUNT = 10;
        this.secondaryJmsServer.createQueue(true, "mdbQueue", null, true, new String[]{"/jms/mdbQueue"});
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setRebalanceConnections(Boolean.valueOf(true));
        spec.setMaxSession(Integer.valueOf(10));
        spec.setSetupAttempts(Integer.valueOf(5));
        spec.setSetupInterval(Long.valueOf(200L));
        spec.setRetryInterval(Long.valueOf(100L));
        spec.setReconnectAttempts(Integer.valueOf(reconnectAttempts));
        spec.setHA(Boolean.valueOf(true));
        spec.setCallTimeout(Long.valueOf(500L));
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Queue primaryQueue = this.server.locateQueue(MDBQUEUEPREFIXEDSIMPLE);
        Queue secondaryQueue = this.secondaryServer.locateQueue(MDBQUEUEPREFIXEDSIMPLE);
        Assertions.assertTrue((primaryQueue.getConsumerCount() < 10 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((secondaryQueue.getConsumerCount() < 10 ? (byte)1 : 0) != 0);
        Assertions.assertTrue((primaryQueue.getConsumerCount() + secondaryQueue.getConsumerCount() == 10 ? (byte)1 : 0) != 0);
        ClientSession session = this.addClientSession(this.locator.createSessionFactory().createSession());
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("test");
        clientProducer.send((Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"test");
        try {
            for (int i = 0; i < 10; ++i) {
                this.secondaryServer.stop();
                Wait.assertTrue(() -> primaryQueue.getConsumerCount() == 10);
                this.secondaryServer.start();
                this.waitForServerToStart(this.secondaryServer);
                Queue secondaryQueueRef = secondaryQueue = this.secondaryServer.locateQueue(MDBQUEUEPREFIXEDSIMPLE);
                Wait.assertTrue(() -> primaryQueue.getConsumerCount() <= 10);
                Wait.assertTrue(() -> secondaryQueueRef.getConsumerCount() <= 10);
                Wait.assertTrue(() -> primaryQueue.getConsumerCount() + secondaryQueueRef.getConsumerCount() == 10);
            }
        }
        finally {
            qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
            qResourceAdapter.stop();
        }
    }
}

