/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.impl.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NettyConnectionTest
extends ActiveMQTestBase {
    private static final Map<String, Object> emptyMap = Collections.emptyMap();

    @Test
    public void testGetID() throws Exception {
        EmbeddedChannel channel = NettyConnectionTest.createChannel();
        NettyConnection conn = new NettyConnection(emptyMap, (Channel)channel, (BaseConnectionLifeCycleListener)new MyListener(), false, false);
        Assertions.assertEquals((Object)channel.id(), (Object)conn.getID());
    }

    @Test
    public void testWrite() throws Exception {
        ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(128));
        EmbeddedChannel channel = NettyConnectionTest.createChannel();
        Assertions.assertEquals((int)0, (int)channel.outboundMessages().size());
        NettyConnection conn = new NettyConnection(emptyMap, (Channel)channel, (BaseConnectionLifeCycleListener)new MyListener(), false, false);
        conn.write(buff);
        channel.runPendingTasks();
        Assertions.assertEquals((int)1, (int)channel.outboundMessages().size());
    }

    @Test
    public void testCreateBuffer() throws Exception {
        EmbeddedChannel channel = NettyConnectionTest.createChannel();
        NettyConnection conn = new NettyConnection(emptyMap, (Channel)channel, (BaseConnectionLifeCycleListener)new MyListener(), false, false);
        int size = 1234;
        ActiveMQBuffer buff = conn.createTransportBuffer(1234);
        buff.writeByte((byte)0);
        Assertions.assertEquals((int)1234, (int)buff.capacity());
    }

    @Test
    public void throwsExceptionOnBlockUntilWritableIfClosed() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            EmbeddedChannel channel = NettyConnectionTest.createChannel();
            NettyConnection conn = new NettyConnection(emptyMap, (Channel)channel, (BaseConnectionLifeCycleListener)new MyListener(), false, false);
            conn.close();
            channel.runPendingTasks();
            conn.blockUntilWritable(0L, TimeUnit.NANOSECONDS);
        });
    }

    @Test
    public void testIsTargetNode() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("host", "localhost");
        config.put("port", "1234");
        HashMap<String, String> config1 = new HashMap<String, String>();
        config1.put("host", "localhost");
        config1.put("port", "1234");
        TransportConfiguration tf1 = new TransportConfiguration(NettyConnectorFactory.class.getName(), config1, "tf1");
        HashMap<String, String> config2 = new HashMap<String, String>();
        config2.put("host", "127.0.0.1");
        config2.put("port", "1234");
        TransportConfiguration tf2 = new TransportConfiguration(NettyConnectorFactory.class.getName(), config2, "tf2");
        HashMap<String, String> config3 = new HashMap<String, String>();
        config3.put("host", "otherhost");
        config3.put("port", "1234");
        TransportConfiguration tf3 = new TransportConfiguration(NettyConnectorFactory.class.getName(), config3, "tf3");
        HashMap<String, String> config4 = new HashMap<String, String>();
        config4.put("host", "127.0.0.1");
        config4.put("port", "9999");
        TransportConfiguration tf4 = new TransportConfiguration(NettyConnectorFactory.class.getName(), config4, "tf4");
        HashMap<String, String> config5 = new HashMap<String, String>();
        config5.put("host", "127.0.0.2");
        config5.put("port", "1234");
        TransportConfiguration tf5 = new TransportConfiguration(NettyConnectorFactory.class.getName(), config5, "tf5");
        HashMap<String, String> config6 = new HashMap<String, String>();
        config6.put("host", "127.0.0.2");
        config6.put("port", "1234");
        TransportConfiguration tf6 = new TransportConfiguration("some.other.FactoryClass", config6, "tf6");
        EmbeddedChannel channel = NettyConnectionTest.createChannel();
        NettyConnection conn = new NettyConnection(config, (Channel)channel, (BaseConnectionLifeCycleListener)new MyListener(), false, false);
        Assertions.assertTrue((boolean)conn.isSameTarget(new TransportConfiguration[]{tf1}));
        Assertions.assertTrue((boolean)conn.isSameTarget(new TransportConfiguration[]{tf2}));
        Assertions.assertTrue((boolean)conn.isSameTarget(new TransportConfiguration[]{tf1, tf2}));
        Assertions.assertFalse((boolean)conn.isSameTarget(new TransportConfiguration[]{tf3}));
        Assertions.assertTrue((boolean)conn.isSameTarget(new TransportConfiguration[]{tf3, tf1}));
        Assertions.assertTrue((boolean)conn.isSameTarget(new TransportConfiguration[]{tf3, tf2}));
        Assertions.assertTrue((boolean)conn.isSameTarget(new TransportConfiguration[]{tf1, tf3}));
        Assertions.assertFalse((boolean)conn.isSameTarget(new TransportConfiguration[]{tf4}));
        Assertions.assertFalse((boolean)conn.isSameTarget(new TransportConfiguration[]{tf5}));
        Assertions.assertFalse((boolean)conn.isSameTarget(new TransportConfiguration[]{tf4, tf5}));
        Assertions.assertFalse((boolean)conn.isSameTarget(new TransportConfiguration[]{tf6}));
        Assertions.assertTrue((boolean)conn.isSameTarget(new TransportConfiguration[]{tf1, tf6}));
        Assertions.assertTrue((boolean)conn.isSameTarget(new TransportConfiguration[]{tf6, tf2}));
    }

    private static EmbeddedChannel createChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
    }

    class MyListener
    implements ClientConnectionLifeCycleListener {
        MyListener() {
        }

        public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
        }

        public void connectionDestroyed(Object connectionID, boolean failed) {
        }

        public void connectionException(Object connectionID, ActiveMQException me) {
        }

        public void connectionReadyForWrites(Object connectionID, boolean ready) {
        }
    }
}

