/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import java.io.File;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;

public class ColocatedActiveMQServer
extends ActiveMQServerImpl {
    private final NodeManager nodeManagerPrimary;
    private final NodeManager nodeManagerBackup;
    boolean backup = false;
    public ColocatedActiveMQServer backupServer;

    public ColocatedActiveMQServer(FileConfiguration fc, ActiveMQSecurityManager sm, NodeManager nodeManagerPrimary, NodeManager nodeManagerBackup) {
        super((Configuration)fc, sm);
        this.nodeManagerPrimary = nodeManagerPrimary;
        this.nodeManagerBackup = nodeManagerBackup;
    }

    public ColocatedActiveMQServer(Configuration backupServerConfiguration, ActiveMQServer parentServer, NodeManager nodeManagerBackup, NodeManager nodeManagerPrimary) {
        super(backupServerConfiguration, null, null, parentServer);
        this.nodeManagerPrimary = nodeManagerPrimary;
        this.nodeManagerBackup = nodeManagerBackup;
    }

    public ColocatedActiveMQServer(Configuration configuration, MBeanServer platformMBeanServer, ActiveMQSecurityManager securityManager, NodeManager nodeManagerPrimary, NodeManager nodeManagerBackup) {
        super(configuration, platformMBeanServer, securityManager);
        this.nodeManagerPrimary = nodeManagerPrimary;
        this.nodeManagerBackup = nodeManagerBackup;
    }

    protected NodeManager createNodeManager(File directory, boolean replicatingBackup) {
        if (replicatingBackup) {
            return new FileLockNodeManager(directory, replicatingBackup, this.getConfiguration().getJournalLockAcquisitionTimeout(), null);
        }
        if (this.backup) {
            return this.nodeManagerBackup;
        }
        return this.nodeManagerPrimary;
    }

    public ActiveMQServer createBackupServer(Configuration configuration) {
        ColocatedActiveMQServer backup = new ColocatedActiveMQServer(configuration, (ActiveMQServer)this, this.nodeManagerBackup, this.nodeManagerPrimary);
        backup.backup = true;
        this.backupServer = backup;
        return backup;
    }
}

