/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability.common.ant;

import com.arjuna.orbportability.logging.opLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public class IDLCompiler
extends Task {
    private static final String NAME_ELEMENT = "name";
    private static final String VALUE_ELEMENT = "value";
    protected String _parameters = null;
    protected String _orb = null;
    protected Hashtable _idlCompilerDefinitions = null;
    protected String _filename = null;
    protected String _destinationDirectory = null;
    protected String _packageName = null;
    protected String _buildList = null;
    protected boolean _debugOn = false;
    protected boolean _verbose = false;
    protected FileSet _fileSet = null;

    public IDLCompiler() {
        this.parseIDLCompilerDefinitionsFile();
    }

    public final void setDebug(String debug) {
        this._debugOn = Boolean.parseBoolean(debug);
    }

    public final void setVerbose(String verbose) {
        this._verbose = Boolean.parseBoolean(verbose);
    }

    public final void setDestdir(String destDir) {
        this._destinationDirectory = destDir;
    }

    public void setBuildlist(String buildList) {
        this._buildList = buildList;
    }

    public final void setPackage(String packageName) {
        this._packageName = packageName;
    }

    public final void setParameters(String parameters) {
        this._parameters = parameters;
    }

    public final void setFilename(String filename) {
        this._filename = filename;
    }

    public final void setOrb(String orb) {
        this._orb = orb;
    }

    protected boolean childrenContainsSubParam(Node n) {
        NodeList children = n.getChildNodes();
        boolean found = false;
        for (int count = 0; count < children.getLength() && !found; found |= children.item(count).getNodeName().equalsIgnoreCase("sub-param"), ++count) {
        }
        return found;
    }

    protected void parseIDLCompilerDefinitionsFile() throws BuildException {
        this._idlCompilerDefinitions = new Hashtable();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream configIn = ((Object)((Object)this)).getClass().getResourceAsStream("/idl-compiler-definitions.xml");
            if (configIn == null) {
                throw new BuildException("Cannot find idl-compiler-definitions.xml in your classpath");
            }
            Document doc = db.parse(configIn);
            Element root = doc.getDocumentElement();
            NodeList supportedOrbs = root.getChildNodes();
            for (int count = 0; count < supportedOrbs.getLength(); ++count) {
                Node orbConfig = supportedOrbs.item(count);
                if (!orbConfig.getNodeName().equalsIgnoreCase("orb")) continue;
                IDLCompilerDetails idlDetails = new IDLCompilerDetails();
                idlDetails.setORBName(orbConfig.getAttributes().getNamedItem(NAME_ELEMENT).getNodeValue());
                NodeList orbDef = orbConfig.getChildNodes();
                for (int orbDefCount = 0; orbDefCount < orbDef.getLength(); ++orbDefCount) {
                    int inCount;
                    Node orbDefNode = orbDef.item(orbDefCount);
                    String nodeName = orbDefNode.getNodeName();
                    if (nodeName.equalsIgnoreCase("idl-executable")) {
                        idlDetails.setIDLExecutable(orbDefNode.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase("in-parameters")) {
                        NodeList inParameters = orbDefNode.getChildNodes();
                        for (inCount = 0; inCount < inParameters.getLength(); ++inCount) {
                            Node inParamNode = inParameters.item(inCount);
                            if (!inParamNode.getNodeName().equals("param")) continue;
                            NamedNodeMap paramAttributes = inParamNode.getAttributes();
                            String name = paramAttributes.getNamedItem(NAME_ELEMENT).getNodeValue();
                            boolean required = Boolean.parseBoolean(paramAttributes.getNamedItem("required").getNodeValue());
                            String delimiter = null;
                            String replace = null;
                            boolean isClasspath = false;
                            Node isClasspathNode = paramAttributes.getNamedItem("classpath");
                            Node delimiterNode = paramAttributes.getNamedItem("delimiter");
                            Node replaceNode = paramAttributes.getNamedItem("replace");
                            if (delimiterNode != null) {
                                delimiter = delimiterNode.getNodeValue();
                            }
                            if (replaceNode != null) {
                                replace = replaceNode.getNodeValue();
                            }
                            if (isClasspathNode != null) {
                                isClasspath = Boolean.parseBoolean(isClasspathNode.getNodeValue());
                            }
                            idlDetails.addInParameter(name, required, delimiter, isClasspath, replace);
                        }
                        continue;
                    }
                    if (!nodeName.equalsIgnoreCase("out-parameters")) continue;
                    NodeList outParameters = orbDefNode.getChildNodes();
                    for (inCount = 0; inCount < outParameters.getLength(); ++inCount) {
                        Node outParamNode = outParameters.item(inCount);
                        if (!outParamNode.getNodeName().equals("param")) continue;
                        Node forEachNode = outParamNode.getAttributes().getNamedItem("foreach");
                        if (this.childrenContainsSubParam(outParamNode)) {
                            NodeList children = outParamNode.getChildNodes();
                            ArrayList<String> multiParam = new ArrayList<String>();
                            for (int subParamCount = 0; subParamCount < children.getLength(); ++subParamCount) {
                                Node child = children.item(subParamCount);
                                if (!child.getNodeName().equalsIgnoreCase("sub-param")) continue;
                                multiParam.add(child.getFirstChild().getNodeValue());
                            }
                            if (forEachNode != null) {
                                idlDetails.addOutParameter(multiParam, forEachNode.getNodeValue());
                                continue;
                            }
                            idlDetails.addOutParameter(multiParam);
                            continue;
                        }
                        if (forEachNode != null) {
                            idlDetails.addOutParameter(outParamNode.getFirstChild().getNodeValue(), forEachNode.getNodeValue());
                            continue;
                        }
                        idlDetails.addOutParameter(outParamNode.getFirstChild().getNodeValue());
                    }
                }
                this._idlCompilerDefinitions.put(idlDetails.getORBName(), idlDetails);
            }
        }
        catch (Exception e) {
            throw new BuildException("An unexpected exception occurred while processing the idl compiler definitions file (" + String.valueOf(e) + ")");
        }
    }

    private String[] createExecArray(String data) {
        int count = 0;
        StringTokenizer st = new StringTokenizer(data);
        String[] results = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            results[count++] = st.nextToken();
        }
        return results;
    }

    protected String stripDirectory(String filename) {
        String result = new File(filename).getParent();
        return result == null ? "" : result;
    }

    public void execute() throws BuildException {
        if (this._orb == null) {
            throw new BuildException("You have not specified the name of the ORB to build against.");
        }
        IDLCompilerDetails idlCompiler = (IDLCompilerDetails)this._idlCompilerDefinitions.get(this._orb);
        if (idlCompiler == null) {
            throw new BuildException("The IDL compiler for '" + this._orb + "' is not defined within the configuration file");
        }
        if (this._buildList != null) {
            this.log("Parsing...");
            BuildListParser blp = new BuildListParser(this._buildList);
            if (this._buildList != null && !blp.isValid() && this._buildList.length() > 0) {
                throw new BuildException("The IDL build list is invalid!");
            }
            while (blp.getNextElement()) {
                String mappings;
                String packageName;
                String source = blp.getSource();
                if (this.processIDL(idlCompiler, source, packageName = blp.getPackage(), this._destinationDirectory, mappings = blp.getMappings())) continue;
                throw new BuildException("Failed to compile '" + source + "' file");
            }
        } else {
            if (this._filename == null) {
                throw new BuildException("No source filename has been given");
            }
            if (this._packageName == null) {
                throw new BuildException("No package name has been given");
            }
            this.log("Processing '" + this._filename + "'");
            if (!this.processIDL(idlCompiler, this._filename, this._packageName, this._destinationDirectory, "")) {
                throw new BuildException("Failed to compile '" + this._filename + "' file");
            }
        }
    }

    public boolean processIDL(IDLCompilerDetails idlCompiler, String filename, String packageName, String destDir, String mappings) {
        boolean returnValue = false;
        this.log("Processing for " + idlCompiler.getORBName() + " '" + filename + "'");
        if (this._verbose) {
            this.log("Package: " + packageName);
            this.log("Parameters: " + this._parameters);
            this.log("Mappings: " + mappings);
            this.log("Destination Directory: " + destDir);
        }
        try {
            Process idlProc;
            String[] idlParameters = idlCompiler.parse(filename, destDir, packageName, this._parameters, mappings);
            String[] idlExec = this.createExecArray(idlCompiler.getCompilerExecutable());
            String[] execParameters = new String[idlExec.length + idlParameters.length];
            System.arraycopy(idlExec, 0, execParameters, 0, idlExec.length);
            System.arraycopy(idlParameters, 0, execParameters, idlExec.length, idlParameters.length);
            Runtime rt = Runtime.getRuntime();
            if (this._debugOn) {
                for (int count = 0; count < execParameters.length; ++count) {
                    this.log("Param[" + count + "] = '" + execParameters[count] + "'");
                }
            }
            if ((idlProc = rt.exec(execParameters)) == null) {
                throw new BuildException("Failed to run IDL compiler");
            }
            new InputStreamFileWriter(idlProc.getInputStream(), "idl-compiler.out");
            new InputStreamFileWriter(idlProc.getErrorStream(), "idl-compiler.err");
            returnValue = idlProc.waitFor() == 0;
        }
        catch (Exception e) {
            this.log(opLogger.i18NLogger.warn_unexpectedexception(e), e, 1);
            throw new BuildException("The following exception occurred while executing the IDL compiler: " + String.valueOf(e));
        }
        return returnValue;
    }

    public class IDLCompilerDetails {
        protected String _orbName;
        protected String _compilerExe;
        protected Hashtable _inParameters;
        protected ArrayList _outParameters;
        protected Hashtable _parameterValueMap = new Hashtable();
        protected Hashtable _forEachMapping = new Hashtable();

        public IDLCompilerDetails() {
            this._inParameters = new Hashtable();
            this._outParameters = new ArrayList();
        }

        public void setIDLExecutable(String idlExe) {
            this._compilerExe = idlExe;
        }

        public void setORBName(String name) {
            this._orbName = name;
        }

        public String getORBName() {
            return this._orbName;
        }

        public String getCompilerExecutable() throws Exception {
            return this.replaceVariables(this._compilerExe, this._parameterValueMap, new HashSet());
        }

        public void addInParameter(String param, boolean required, String delimiter, boolean isClasspath, String replace) {
            this._inParameters.put(param, new InParameterDetails(param, required, delimiter, isClasspath, replace));
        }

        public InParameterDetails getInParameter(String param) {
            return (InParameterDetails)this._inParameters.get(param);
        }

        public void addOutParameter(String param) {
            this._outParameters.add(param);
        }

        public void addOutParameter(String param, String forEach) {
            this._outParameters.add(param);
            this.setForEach(param, forEach);
        }

        public void setForEach(String param, String forEach) {
            this._forEachMapping.put(param, forEach);
        }

        public void addOutParameter(ArrayList params) {
            this._outParameters.add(params);
        }

        public void addOutParameter(ArrayList params, String forEach) {
            this._outParameters.add(params);
            this._forEachMapping.put(params, forEach);
        }

        protected InParameterDetails setAndFlagParameter(String param, String value, Hashtable map) {
            if (value != null) {
                InParameterDetails inParamDef = this.getInParameter(param);
                if (inParamDef == null) {
                    throw new BuildException("The parameter '" + param + "' used in the parameter attribute is not defined for this ORB");
                }
                if (inParamDef.hasDelimiter()) {
                    StringTokenizer st = new StringTokenizer(value, inParamDef.getDelimiter());
                    ArrayList<String> values = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        values.add(st.nextToken());
                    }
                    map.put(param, values);
                } else {
                    map.put(param, value);
                }
                return inParamDef;
            }
            map.put(param, value);
            return null;
        }

        public String[] parse(String filename, String destDir, String packageName, String parameters, String mappings) throws BuildException {
            HashSet<InParameterDetails> usedParameters = new HashSet<InParameterDetails>();
            ArrayList outputParameters = new ArrayList();
            if (filename == null || filename.length() <= 0) {
                throw new BuildException("The filename specified was invalid");
            }
            usedParameters.add(this.setAndFlagParameter("filename", filename, this._parameterValueMap));
            if (destDir != null && destDir.length() > 0) {
                usedParameters.add(this.setAndFlagParameter("destdir", destDir, this._parameterValueMap));
            }
            if (packageName != null && packageName.length() > 0) {
                usedParameters.add(this.setAndFlagParameter("package", packageName, this._parameterValueMap));
            }
            if (mappings != null && mappings.length() > 0) {
                usedParameters.add(this.setAndFlagParameter("mapping", mappings, this._parameterValueMap));
            }
            if (parameters != null) {
                StringTokenizer st;
                ArrayList<String> values;
                InParameterDetails inParamDef;
                Object value;
                String parameter;
                while (parameters.indexOf(44) != -1) {
                    String parameterPair = parameters.substring(0, parameters.indexOf(44));
                    parameter = parameterPair.substring(0, parameterPair.indexOf(61));
                    value = parameterPair.substring(parameterPair.indexOf(61));
                    value = ((String)value).substring(((String)value).indexOf(39) + 1);
                    value = ((String)value).substring(0, ((String)value).indexOf(39));
                    inParamDef = this.getInParameter(parameter);
                    if (inParamDef == null) {
                        throw new BuildException("The parameter '" + parameter + "' used in the parameter attribute is not defined for this ORB");
                    }
                    if (usedParameters.contains(inParamDef)) {
                        throw new BuildException("The parameter '" + parameter + "' has been defined twice");
                    }
                    usedParameters.add(inParamDef);
                    values = new ArrayList();
                    this._parameterValueMap.put(parameter, values);
                    if (inParamDef.hasDelimiter()) {
                        st = new StringTokenizer((String)value, inParamDef.getDelimiter());
                        while (st.hasMoreTokens()) {
                            values.add(st.nextToken());
                        }
                    } else {
                        values.add((String)value);
                    }
                    parameters = parameters.substring(parameters.indexOf(44) + 1);
                }
                parameter = parameters.substring(0, parameters.indexOf(61));
                value = parameters.substring(parameters.indexOf(61));
                value = ((String)value).substring(((String)value).indexOf(39) + 1);
                value = ((String)value).substring(0, ((String)value).indexOf(39));
                inParamDef = this.getInParameter(parameter);
                if (inParamDef == null) {
                    throw new BuildException("The parameter '" + parameter + "' used in the parameter attribute is not defined for this ORB");
                }
                if (usedParameters.contains(inParamDef)) {
                    throw new BuildException("The parameter '" + parameter + "' has been defined twice");
                }
                usedParameters.add(inParamDef);
                values = new ArrayList<String>();
                this._parameterValueMap.put(parameter, values);
                if (inParamDef.hasDelimiter() && !inParamDef.isClasspath()) {
                    st = new StringTokenizer((String)value, inParamDef.getDelimiter());
                    while (st.hasMoreTokens()) {
                        values.add(st.nextToken());
                    }
                } else {
                    if (inParamDef.isClasspath()) {
                        if (!inParamDef.hasDelimiter()) {
                            throw new BuildException("Param defined as classpath but delimiter defined");
                        }
                        value = this.createClasspath((String)value, inParamDef.getDelimiter());
                    }
                    if (inParamDef.getReplaceString() != null) {
                        String replaceString = inParamDef.getReplaceString();
                        String find = replaceString.substring(0, replaceString.indexOf(44));
                        String replaceWith = replaceString.substring(replaceString.indexOf(44) + 1);
                        while (((String)value).indexOf(find) != -1) {
                            value = ((String)value).substring(0, ((String)value).indexOf(find)) + replaceWith + ((String)value).substring(((String)value).indexOf(find) + find.length());
                        }
                    }
                    values.add((String)value);
                }
            }
            Enumeration e = this._inParameters.elements();
            while (e.hasMoreElements()) {
                InParameterDetails ipd = (InParameterDetails)e.nextElement();
                if (!ipd.isRequired() || usedParameters.contains(ipd)) continue;
                throw new BuildException("The parameter '" + ipd.getParameter() + "' is defined as being required but has not been specified");
            }
            for (int count = 0; count < this._outParameters.size(); ++count) {
                if (this._outParameters.get(count) instanceof ArrayList) {
                    ArrayList subParams = (ArrayList)this._outParameters.get(count);
                    ArrayList multiParam = new ArrayList();
                    try {
                        this.generateOutputParameters(subParams, usedParameters, multiParam);
                        outputParameters.addAll(multiParam);
                        continue;
                    }
                    catch (BuildException e2) {
                        throw e2;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                try {
                    this.generateOutputParameters(this._outParameters.get(count), usedParameters, outputParameters);
                    continue;
                }
                catch (BuildException e3) {
                    throw e3;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String[] returnArray = new String[outputParameters.size()];
            System.arraycopy(outputParameters.toArray(), 0, returnArray, 0, outputParameters.size());
            return returnArray;
        }

        private String createClasspath(String value, String delimiter) {
            Object returnValue = "";
            StringTokenizer st = new StringTokenizer(value, delimiter);
            while (st.hasMoreTokens()) {
                returnValue = (String)returnValue + st.nextToken();
                if (!st.hasMoreTokens()) continue;
                returnValue = (String)returnValue + File.pathSeparatorChar;
            }
            return returnValue;
        }

        private void generateOutputParameters(Object forEachKey, HashSet usedParameters, ArrayList outputParameters) throws Exception {
            String forEach = (String)this._forEachMapping.get(forEachKey);
            if (forEach == null) {
                if (forEachKey instanceof ArrayList) {
                    ArrayList al = (ArrayList)forEachKey;
                    for (int count = 0; count < al.size(); ++count) {
                        outputParameters.add(this.replaceVariables((String)al.get(count), this._parameterValueMap, usedParameters));
                    }
                } else {
                    outputParameters.add(this.replaceVariables((String)forEachKey, this._parameterValueMap, usedParameters));
                }
            } else {
                Object obj = this._parameterValueMap.get(forEach);
                if (obj instanceof ArrayList) {
                    ArrayList paramList = (ArrayList)obj;
                    if (paramList != null) {
                        Hashtable newParamValueMap = new Hashtable(this._parameterValueMap);
                        for (int paramCount = 0; paramCount < paramList.size(); ++paramCount) {
                            newParamValueMap.put(forEach, paramList.get(paramCount));
                            if (!(forEachKey instanceof ArrayList)) {
                                outputParameters.add(this.replaceVariables((String)forEachKey, newParamValueMap, usedParameters));
                                continue;
                            }
                            ArrayList forEachArrayList = (ArrayList)forEachKey;
                            for (int count = 0; count < forEachArrayList.size(); ++count) {
                                outputParameters.add(this.replaceVariables((String)forEachArrayList.get(count), newParamValueMap, usedParameters));
                            }
                        }
                    }
                } else {
                    Hashtable newParamValueMap = new Hashtable(this._parameterValueMap);
                    newParamValueMap.put(forEach, obj);
                    outputParameters.add(this.replaceVariables((String)forEachKey, newParamValueMap, usedParameters));
                }
            }
        }

        public String replaceVariables(String data, Hashtable variableValueMap, HashSet usedParameters) throws Exception {
            while (((String)data).indexOf("${") != -1) {
                String variableName = ((String)data).substring(((String)data).indexOf("${") + 2);
                String variableElement = null;
                if (variableName.indexOf(45) != -1 && variableName.indexOf(45) < variableName.indexOf(125)) {
                    variableElement = variableName.substring(variableName.indexOf(45) + 1, variableName.indexOf(125));
                    variableName = variableName.substring(0, variableName.indexOf(45));
                } else {
                    variableName = variableName.substring(0, variableName.indexOf(125));
                }
                String value = null;
                Object obj = variableValueMap.get(variableName);
                value = obj instanceof ArrayList ? (String)((ArrayList)obj).get(0) : (String)obj;
                if (value != null && variableElement != null) {
                    if (variableElement.equalsIgnoreCase(IDLCompiler.NAME_ELEMENT)) {
                        value = value.substring(0, value.indexOf(61));
                    } else if (variableElement.equalsIgnoreCase(IDLCompiler.VALUE_ELEMENT)) {
                        value = value.substring(value.indexOf(61) + 1);
                    } else {
                        throw new BuildException("Unknown variable element '" + variableElement + "'");
                    }
                }
                if (value == null) {
                    InParameterDetails ipd = this.getInParameter(variableName);
                    if (ipd != null && !usedParameters.contains(ipd)) {
                        throw new Exception("Unspecified optional parameter used - ignore this parameter line");
                    }
                    value = variableName;
                }
                data = ((String)data).substring(0, ((String)data).indexOf("${")) + value + ((String)data).substring(((String)data).indexOf(125) + 1);
            }
            return data;
        }

        private class InParameterDetails {
            public String _parameter;
            public boolean _required;
            public String _delimiter;
            public boolean _isClasspath;
            public String _replaceString;

            public InParameterDetails(String param, boolean required, String delimiter, boolean isClasspath, String replaceString) {
                this._parameter = param;
                this._required = required;
                this._delimiter = delimiter;
                this._isClasspath = isClasspath;
                this._replaceString = replaceString;
            }

            public String getParameter() {
                return this._parameter;
            }

            public boolean isClasspath() {
                return this._isClasspath;
            }

            public boolean isRequired() {
                return this._required;
            }

            public String getDelimiter() {
                return this._delimiter;
            }

            public String getReplaceString() {
                return this._replaceString;
            }

            public boolean hasDelimiter() {
                return this._delimiter != null;
            }
        }
    }

    public class BuildListParser {
        protected String _buildList;
        protected String _currentSrc;
        protected String _currentPackage;
        protected String _currentMapping;
        protected boolean _valid = false;

        public BuildListParser(String buildListString) {
            this._buildList = buildListString;
            this._valid = this._buildList.indexOf(60) < this._buildList.indexOf(62);
        }

        public boolean isValid() {
            return this._valid;
        }

        private boolean getNextElement() {
            boolean returnValue = false;
            if (this._valid && this._buildList.indexOf(60) != -1) {
                String element = this._buildList.substring(this._buildList.indexOf(60) + 1);
                element = element.substring(0, element.indexOf(62));
                this._currentSrc = element.substring(element.indexOf(39) + 1);
                this._currentSrc = this._currentSrc.substring(0, this._currentSrc.indexOf(39));
                element = element.substring(element.indexOf(44) + 1);
                this._currentPackage = element.substring(element.indexOf(39) + 1);
                this._currentPackage = this._currentPackage.substring(0, this._currentPackage.indexOf(39));
                element = element.substring(element.indexOf(44) + 1);
                this._currentMapping = element.substring(element.indexOf(39) + 1);
                this._currentMapping = this._currentMapping.substring(0, this._currentMapping.indexOf(39));
                this._buildList = this._buildList.substring(1).substring(this._buildList.indexOf(62));
                returnValue = true;
            }
            return returnValue;
        }

        public String getSource() {
            return this._currentSrc;
        }

        public String getPackage() {
            return this._currentPackage;
        }

        public String getMappings() {
            return this._currentMapping;
        }
    }

    public class InputStreamFileWriter
    extends Thread {
        InputStream _inStream = null;
        FileOutputStream _outStream = null;

        public InputStreamFileWriter(InputStream inStr, String filename) throws FileNotFoundException, IOException {
            File inFile = new File(filename);
            String directory = filename.substring(0, filename.indexOf(inFile.getName()));
            File inDir = new File(directory);
            inDir.mkdirs();
            this._inStream = inStr;
            this._outStream = new FileOutputStream(inFile);
            this.start();
        }

        @Override
        public void run() {
            try {
                int bytesRead;
                byte[] buffer = new byte[32768];
                while ((bytesRead = this._inStream.read(buffer)) != -1) {
                    if (bytesRead == 0) continue;
                    this._outStream.write(buffer, 0, bytesRead);
                    this._outStream.flush();
                }
                this._outStream.close();
            }
            catch (Exception e) {
                IDLCompiler.this.log(opLogger.i18NLogger.warn_unexpectedexception(e), e, 1);
            }
        }

        public void close() throws IOException {
            this._outStream.close();
        }
    }
}

