/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.configuration.ClusterConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.client.hotrod.configuration.SecurityConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SslConfigurationBuilder;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.infinispan.jmx.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.subsystem.remote.ClientThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodMarshallerFactory;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteClusterResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.SecurityResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.client.service.HotRodServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public enum RemoteCacheContainerConfigurationServiceConfigurator implements ResourceServiceConfigurator
{
    INSTANCE;


    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        final int connectionTimeout = RemoteCacheContainerResourceDefinition.Attribute.CONNECTION_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final String defaultRemoteCluster = RemoteCacheContainerResourceDefinition.Attribute.DEFAULT_REMOTE_CLUSTER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final int maxRetries = RemoteCacheContainerResourceDefinition.Attribute.MAX_RETRIES.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final ProtocolVersion version = ProtocolVersion.parseVersion((String)RemoteCacheContainerResourceDefinition.Attribute.PROTOCOL_VERSION.resolveModelAttribute((ExpressionResolver)context, model).asString());
        final int socketTimeout = RemoteCacheContainerResourceDefinition.Attribute.SOCKET_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final boolean tcpNoDelay = RemoteCacheContainerResourceDefinition.Attribute.TCP_NO_DELAY.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean tcpKeepAlive = RemoteCacheContainerResourceDefinition.Attribute.TCP_KEEP_ALIVE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean statisticsEnabled = RemoteCacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final long transactionTimeout = RemoteCacheContainerResourceDefinition.Attribute.TRANSACTION_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        final HotRodMarshallerFactory marshallerFactory = HotRodMarshallerFactory.valueOf(RemoteCacheContainerResourceDefinition.Attribute.MARSHALLER.resolveModelAttribute((ExpressionResolver)context, model).asString());
        final TreeMap clusters = new TreeMap();
        Resource container = context.readResource(PathAddress.EMPTY_ADDRESS);
        for (Object entry : container.getChildren(RemoteClusterResourceDefinition.WILDCARD_PATH.getKey())) {
            String clusterName = entry.getName();
            ModelNode cluster = entry.getModel();
            List bindingNames = RemoteClusterResourceDefinition.Attribute.SOCKET_BINDINGS.resolveModelAttribute((ExpressionResolver)context, cluster).asListOrEmpty();
            ArrayList<ServiceDependency> bindings = new ArrayList<ServiceDependency>(bindingNames.size());
            for (ModelNode bindingName : bindingNames) {
                bindings.add(ServiceDependency.on((UnaryServiceDescriptor)OutboundSocketBinding.SERVICE_DESCRIPTOR, (String)bindingName.asString()));
            }
            clusters.put(clusterName, bindings);
        }
        final EnumMap<ClientThreadPoolResourceDefinition, ServiceDependency> pools = new EnumMap<ClientThreadPoolResourceDefinition, ServiceDependency>(ClientThreadPoolResourceDefinition.class);
        for (ClientThreadPoolResourceDefinition pool : EnumSet.allOf(ClientThreadPoolResourceDefinition.class)) {
            pools.put(pool, ServiceDependency.on((UnaryServiceDescriptor)pool, (String)name));
        }
        final ServiceDependency server = context.hasOptionalCapability(CommonServiceDescriptor.MBEAN_SERVER, RemoteCacheContainerResourceDefinition.REMOTE_CACHE_CONTAINER_CONFIGURATION, null) ? ServiceDependency.on((NullaryServiceDescriptor)CommonServiceDescriptor.MBEAN_SERVER) : ServiceDependency.of(null);
        final ServiceDependency containerModules = ServiceDependency.on((UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER_MODULES, (String)name);
        final ServiceDependency security = ServiceDependency.on(SecurityResourceDefinition.SERVICE_DESCRIPTOR, (String)name);
        final ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        final Properties properties = new Properties();
        for (Property property : RemoteCacheContainerResourceDefinition.Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, model).asPropertyListOrEmpty()) {
            properties.setProperty(property.getName(), property.getValue().asString());
        }
        Supplier<Configuration> configurationFactory = new Supplier<Configuration>(){

            @Override
            public Configuration get() {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.security().read((Object)((SecurityConfiguration)security.get()));
                MBeanServerLookup serverProvider = Optional.ofNullable((MBeanServer)server.get()).map(MBeanServerProvider::new).orElse(null);
                builder.withProperties(properties).connectionTimeout(connectionTimeout).maxRetries(maxRetries).version(version).socketTimeout(socketTimeout).statistics().enabled(statisticsEnabled).jmxDomain("org.wildfly.clustering.infinispan").jmxEnabled(serverProvider != null).jmxName(name).mBeanServerLookup(serverProvider).tcpNoDelay(tcpNoDelay).tcpKeepAlive(tcpKeepAlive).transactionTimeout(transactionTimeout, TimeUnit.MILLISECONDS);
                List modules = (List)containerModules.get();
                Marshaller marshaller = (Marshaller)marshallerFactory.apply((ModuleLoader)loader.get(), modules);
                builder.marshaller(marshaller);
                builder.asyncExecutorFactory().read((Object)((ExecutorFactoryConfiguration)((ServiceDependency)pools.get(ClientThreadPoolResourceDefinition.ASYNC)).get()));
                for (Map.Entry entry : clusters.entrySet()) {
                    String clusterName = (String)entry.getKey();
                    ClusterConfigurator<ServerConfigurationBuilder> configurator = defaultRemoteCluster.equals(clusterName) ? DefaultClusterConfigurator.INSTANCE : new NonDefaultClusterConfigurator(clusterName);
                    this.configureCluster(builder, configurator, (Collection)entry.getValue());
                }
                return builder.build();
            }

            private <C extends ConfigurationChildBuilder> void configureCluster(ConfigurationBuilder builder, ClusterConfigurator<C> configurator, Collection<ServiceDependency<OutboundSocketBinding>> dependencies) {
                C cluster = configurator.addCluster(builder);
                for (Supplier supplier : dependencies) {
                    OutboundSocketBinding binding = (OutboundSocketBinding)supplier.get();
                    configurator.getBindingConsumer(cluster).accept(binding.getUnresolvedDestinationAddress(), binding.getDestinationPort());
                }
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(RemoteCacheContainerResourceDefinition.REMOTE_CACHE_CONTAINER_CONFIGURATION, (Supplier)configurationFactory).requires(List.of(server, containerModules, security, loader))).requires(pools.values())).requires((Iterable)clusters.values().stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableList()))).build();
    }

    static class NonDefaultClusterConfigurator
    implements ClusterConfigurator<ClusterConfigurationBuilder> {
        private final String clusterName;

        NonDefaultClusterConfigurator(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public ClusterConfigurationBuilder addCluster(ConfigurationBuilder builder) {
            return builder.addCluster(this.clusterName);
        }

        @Override
        public ObjIntConsumer<String> getBindingConsumer(ClusterConfigurationBuilder cluster) {
            return (arg_0, arg_1) -> ((ClusterConfigurationBuilder)cluster).addClusterNode(arg_0, arg_1);
        }

        @Override
        public Consumer<String> getSNIHostNameConsumer(ClusterConfigurationBuilder cluster) {
            return arg_0 -> ((ClusterConfigurationBuilder)cluster).clusterSniHostName(arg_0);
        }
    }

    static enum DefaultClusterConfigurator implements ClusterConfigurator<ServerConfigurationBuilder>
    {
        INSTANCE;


        @Override
        public ServerConfigurationBuilder addCluster(ConfigurationBuilder builder) {
            return builder.addServer();
        }

        @Override
        public ObjIntConsumer<String> getBindingConsumer(final ServerConfigurationBuilder server) {
            return new ObjIntConsumer<String>(){

                @Override
                public void accept(String host, int port) {
                    server.host(host).port(port);
                }
            };
        }

        @Override
        public Consumer<String> getSNIHostNameConsumer(ServerConfigurationBuilder server) {
            return arg_0 -> ((SslConfigurationBuilder)server.security().ssl()).sniHostName(arg_0);
        }
    }

    static interface ClusterConfigurator<B extends ConfigurationChildBuilder> {
        public B addCluster(ConfigurationBuilder var1);

        public ObjIntConsumer<String> getBindingConsumer(B var1);

        public Consumer<String> getSNIHostNameConsumer(B var1);
    }
}

