/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentIndexingWork;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.util.common.impl.Futures;

class ElasticsearchIndexIndexingPlanExecution {
    private final ElasticsearchSerialWorkOrchestrator orchestrator;
    private final EntityReferenceFactory entityReferenceFactory;
    private final List<SingleDocumentIndexingWork> works;
    private final CompletableFuture<Void>[] futures;

    ElasticsearchIndexIndexingPlanExecution(ElasticsearchSerialWorkOrchestrator orchestrator, EntityReferenceFactory entityReferenceFactory, List<SingleDocumentIndexingWork> works) {
        this.orchestrator = orchestrator;
        this.entityReferenceFactory = entityReferenceFactory;
        this.works = works;
        this.futures = new CompletableFuture[works.size()];
        for (int i = 0; i < this.futures.length; ++i) {
            this.futures[i] = new CompletableFuture();
        }
    }

    CompletableFuture<MultiEntityOperationExecutionReport> execute(OperationSubmitter operationSubmitter) {
        CompletionStage reportFuture = CompletableFuture.allOf(this.futures).handle((result, throwable) -> this.onAllWorksFinished());
        for (int i = 0; i < this.works.size(); ++i) {
            CompletableFuture<Void> future = this.futures[i];
            SingleDocumentIndexingWork work = this.works.get(i);
            this.orchestrator.submit(future, work, operationSubmitter);
        }
        return reportFuture;
    }

    private MultiEntityOperationExecutionReport onAllWorksFinished() {
        return this.buildReport();
    }

    private MultiEntityOperationExecutionReport buildReport() {
        MultiEntityOperationExecutionReport.Builder reportBuilder = MultiEntityOperationExecutionReport.builder();
        for (int i = 0; i < this.futures.length; ++i) {
            CompletableFuture<Void> future = this.futures[i];
            if (!future.isCompletedExceptionally()) continue;
            reportBuilder.throwable(Futures.getThrowableNow(future));
            SingleDocumentIndexingWork work = this.works.get(i);
            reportBuilder.failingEntityReference(this.entityReferenceFactory, work.getEntityTypeName(), work.getEntityIdentifier());
        }
        return reportBuilder.build();
    }
}

