/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.index;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Result;
import org.jboss.jandex.TypeTarget;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedConstructor;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedField;
import org.wildfly.unstable.api.annotation.classpath.index.AnnotatedMethod;
import org.wildfly.unstable.api.annotation.classpath.index.JarAnnotationIndex;

public class JarAnnotationIndexer {
    private final File file;
    private final String unstableApiAnnotation;
    private final Set<String> excludedClasses;

    public JarAnnotationIndexer(File file, String annotation, Set<String> excludedClasses) {
        if (file == null || annotation == null || excludedClasses == null) {
            throw new NullPointerException("Null parameter");
        }
        this.file = file;
        this.unstableApiAnnotation = annotation;
        this.excludedClasses = excludedClasses;
    }

    public JarAnnotationIndex scanForAnnotation() throws IOException {
        Indexer indexer = new Indexer();
        Result result = JarIndexer.createJarIndex((File)this.file, (Indexer)indexer, (boolean)false, (boolean)true, (boolean)false);
        Index index = result.getIndex();
        Collection annotations = index.getAnnotations(this.unstableApiAnnotation);
        JarAnnotationIndex.ResultBuilder resultBuilder = JarAnnotationIndex.builder(this.unstableApiAnnotation);
        for (AnnotationInstance annotation : annotations) {
            this.processAnnotationTarget(resultBuilder, annotation.target());
        }
        return resultBuilder.build();
    }

    private void processAnnotationTarget(JarAnnotationIndex.ResultBuilder resultBuilder, AnnotationTarget target) {
        FieldInfo fieldInfo;
        ClassInfo classInfo;
        String className;
        if (target.kind() == AnnotationTarget.Kind.TYPE) {
            AnnotationTarget enclosingTarget = ((TypeTarget)target).enclosingTarget();
            this.processAnnotationTarget(resultBuilder, enclosingTarget);
        }
        if (target.kind() == AnnotationTarget.Kind.CLASS) {
            ClassInfo classInfo2 = target.asClass();
            String className2 = classInfo2.name().toString();
            if (!this.excludedClasses.contains(className2)) {
                if (classInfo2.isAnnotation()) {
                    resultBuilder.addAnnotatedAnnotation(className2);
                } else if (classInfo2.isInterface()) {
                    resultBuilder.addAnnotatedInterface(className2);
                } else if (classInfo2.isDeclaration()) {
                    resultBuilder.addAnnotatedClass(className2);
                }
            }
        } else if (target.kind() == AnnotationTarget.Kind.METHOD || target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            MethodInfo methodInfo = target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER ? target.asMethodParameter().method() : target.asMethod();
            ClassInfo classInfo3 = methodInfo.declaringClass();
            String className3 = classInfo3.name().toString();
            if (!this.excludedClasses.contains(className3)) {
                if (methodInfo.isConstructor()) {
                    AnnotatedConstructor annotatedConstructor = new AnnotatedConstructor(className3, methodInfo.descriptor());
                    resultBuilder.addAnnotatedConstructor(annotatedConstructor);
                } else {
                    AnnotatedMethod annotatedMethod = new AnnotatedMethod(className3, methodInfo.name(), methodInfo.descriptor());
                    resultBuilder.addAnnotatedMethod(annotatedMethod);
                }
            }
        } else if (target.kind() == AnnotationTarget.Kind.FIELD && !this.excludedClasses.contains(className = (classInfo = (fieldInfo = target.asField()).declaringClass()).name().toString())) {
            AnnotatedField annotatedField = new AnnotatedField(className, fieldInfo.name());
            resultBuilder.addAnnotatedField(annotatedField);
        }
    }
}

