/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.rmi;

import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.rmi.ClassAnalysis;

public class PrimitiveAnalysis
extends ClassAnalysis {
    public static final PrimitiveAnalysis voidAnalysis = new PrimitiveAnalysis(Void.TYPE, "void", "void");
    public static final PrimitiveAnalysis booleanAnalysis = new PrimitiveAnalysis(Boolean.TYPE, "boolean", "boolean");
    public static final PrimitiveAnalysis charAnalysis = new PrimitiveAnalysis(Character.TYPE, "wchar", "char");
    public static final PrimitiveAnalysis byteAnalysis = new PrimitiveAnalysis(Byte.TYPE, "octet", "byte");
    public static final PrimitiveAnalysis shortAnalysis = new PrimitiveAnalysis(Short.TYPE, "short", "short");
    public static final PrimitiveAnalysis intAnalysis = new PrimitiveAnalysis(Integer.TYPE, "long", "int");
    public static final PrimitiveAnalysis longAnalysis = new PrimitiveAnalysis(Long.TYPE, "long_long", "long");
    public static final PrimitiveAnalysis floatAnalysis = new PrimitiveAnalysis(Float.TYPE, "float", "float");
    public static final PrimitiveAnalysis doubleAnalysis = new PrimitiveAnalysis(Double.TYPE, "double", "double");

    private PrimitiveAnalysis(Class cls, String idlName, String javaName) {
        super(cls, idlName, javaName);
    }

    public static PrimitiveAnalysis getPrimitiveAnalysis(Class cls) {
        if (cls == null) {
            throw IIOPLogger.ROOT_LOGGER.cannotAnalyzeNullClass();
        }
        if (cls == Void.TYPE) {
            return voidAnalysis;
        }
        if (cls == Boolean.TYPE) {
            return booleanAnalysis;
        }
        if (cls == Character.TYPE) {
            return charAnalysis;
        }
        if (cls == Byte.TYPE) {
            return byteAnalysis;
        }
        if (cls == Short.TYPE) {
            return shortAnalysis;
        }
        if (cls == Integer.TYPE) {
            return intAnalysis;
        }
        if (cls == Long.TYPE) {
            return longAnalysis;
        }
        if (cls == Float.TYPE) {
            return floatAnalysis;
        }
        if (cls == Double.TYPE) {
            return doubleAnalysis;
        }
        throw IIOPLogger.ROOT_LOGGER.notAPrimitive(cls.getName());
    }
}

