/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.WeakHashMap;

public final class ElapsedTime {
    private volatile Long startTime;
    private final Map<ElapsedTime, Object> checkpoints = new WeakHashMap<ElapsedTime, Object>();

    public static ElapsedTime startingFromJvmStart() {
        return new ElapsedTime(null);
    }

    public static ElapsedTime startingFromNow() {
        return new ElapsedTime(System.currentTimeMillis());
    }

    private ElapsedTime(Long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime != null ? this.startTime.longValue() : ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    public long getElapsedTime() {
        return this.startTime == null ? ManagementFactory.getRuntimeMXBean().getUptime() : System.currentTimeMillis() - this.startTime;
    }

    public synchronized void reset() {
        this.startTime = null;
        for (ElapsedTime checkpoint : this.checkpoints.keySet()) {
            checkpoint.reset();
        }
    }

    public synchronized ElapsedTime checkpoint() {
        ElapsedTime checkpoint = ElapsedTime.startingFromNow();
        this.checkpoints.put(checkpoint, null);
        return checkpoint;
    }
}

