/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.factory;

import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.factory.CacheBaseCounterFactory;
import org.infinispan.counter.impl.factory.StrongCounterFactory;
import org.infinispan.counter.impl.manager.InternalCounterAdmin;
import org.infinispan.counter.impl.strong.AbstractStrongCounter;
import org.infinispan.counter.impl.strong.BoundedStrongCounter;
import org.infinispan.counter.impl.strong.StrongCounterKey;
import org.infinispan.counter.impl.strong.UnboundedStrongCounter;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
public class CacheBasedStrongCounterFactory
extends CacheBaseCounterFactory<StrongCounterKey>
implements StrongCounterFactory {
    @Override
    public CompletionStage<InternalCounterAdmin> createStrongCounter(String name, CounterConfiguration configuration) {
        assert (configuration.type() != CounterType.WEAK);
        return this.cache(configuration).thenCompose(cache -> {
            AbstractStrongCounter counter = configuration.type() == CounterType.BOUNDED_STRONG ? new BoundedStrongCounter(name, (AdvancedCache<StrongCounterKey, CounterValue>)cache, configuration, this.notificationManager) : new UnboundedStrongCounter(name, (AdvancedCache<StrongCounterKey, CounterValue>)cache, configuration, this.notificationManager);
            return counter.init();
        });
    }

    @Override
    public CompletionStage<Void> removeStrongCounter(String name) {
        return this.getCounterCacheAsync().thenCompose(cache -> AbstractStrongCounter.removeStrongCounter((Cache<StrongCounterKey, CounterValue>)cache, name));
    }
}

