/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.AbstractFilePersistenceResource;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.FilePersistenceUtils;
import org.jboss.dmr.ModelNode;

public class ConfigurationFilePersistenceResource
extends AbstractFilePersistenceResource {
    private final ConfigurationFile configurationFile;
    protected final File fileName;

    ConfigurationFilePersistenceResource(ModelNode model, ConfigurationFile configurationFile, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        super(model, persister);
        this.configurationFile = configurationFile;
        this.fileName = configurationFile.getMainFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommit(InputStream in) {
        File tempFileName = FilePersistenceUtils.isParentFolderWritable(this.fileName) ? FilePersistenceUtils.createTempFile(this.fileName) : (Files.isWritable(this.configurationFile.getConfigurationDir().toPath()) ? FilePersistenceUtils.createTempFile(this.configurationFile.getConfigurationDir(), this.fileName.getName()) : FilePersistenceUtils.createTempFile(this.configurationFile.getConfigurationTmpDir(), this.fileName.getName()));
        try {
            try {
                FilePersistenceUtils.writeToTempFile(in, tempFileName, this.fileName);
            }
            catch (Exception e) {
                ControllerLogger.MGMT_OP_LOGGER.failedToStoreConfiguration(e, this.fileName.getName());
                if (tempFileName.exists() && !tempFileName.delete()) {
                    ControllerLogger.MGMT_OP_LOGGER.cannotDeleteTempFile(tempFileName.getName());
                    tempFileName.deleteOnExit();
                }
                return;
            }
            try {
                this.configurationFile.backup();
            }
            finally {
                this.configurationFile.commitTempFile(tempFileName);
            }
            this.configurationFile.fileWritten();
        }
        catch (ConfigurationPersistenceException e) {
            ControllerLogger.MGMT_OP_LOGGER.errorf(e, e.toString(), new Object[0]);
        }
        finally {
            if (tempFileName.exists() && !tempFileName.delete()) {
                ControllerLogger.MGMT_OP_LOGGER.cannotDeleteTempFile(tempFileName.getName());
                tempFileName.deleteOnExit();
            }
        }
    }
}

