/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AmqpDurableReceiverReconnectWithMulticastPrefixTest
extends JMSClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Parameter(index=0)
    public RoutingType routingType;

    @Parameters(name="routingType={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({RoutingType.ANYCAST}, {RoutingType.MULTICAST});
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP";
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        params.put("anycastPrefix", "anycast://");
        params.put("multicastPrefix", "multicast://");
    }

    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        Configuration serverConfig = server.getConfiguration();
        serverConfig.setJournalType(JournalType.NIO);
        Map map = serverConfig.getAddressSettings();
        if (map.size() == 0) {
            AddressSettings as = new AddressSettings();
            map.put("#", as);
        }
        Map.Entry entry = map.entrySet().iterator().next();
        AddressSettings settings = (AddressSettings)entry.getValue();
        settings.setAutoCreateQueues(Boolean.valueOf(true));
        settings.setDefaultAddressRoutingType(this.routingType);
        logger.info("server config, isauto? {}", (Object)((AddressSettings)entry.getValue()).isAutoCreateQueues());
        logger.info("server config, default address routing type? {}", (Object)((AddressSettings)entry.getValue()).getDefaultAddressRoutingType());
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testReattachToDurableNodeAndTryAndReceiveNewlySentMessage() throws Exception {
        String addressName = "test-address";
        String prefixedName = "multicast://test-address";
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver("multicast://test-address", this.getSubscriptionName());
        receiver.detach();
        AddressQueryResult address = this.getProxyToAddress("test-address");
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals(Set.of(RoutingType.MULTICAST), (Object)address.getRoutingTypes());
        Assertions.assertEquals((long)0L, (long)this.lookupSubscriptionQueue().getMessageCount());
        receiver = session.createDurableReceiver("multicast://test-address", this.getSubscriptionName());
        receiver.flow(1);
        Assertions.assertEquals((long)0L, (long)this.lookupSubscriptionQueue().getMessageCount());
        AmqpSender sender = session.createSender("test-address");
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg:1");
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)1, (int)this.lookupSubscriptionQueue().getDeliveringCount());
        sender.close();
        receiver.close();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testReattachToDurableNodeAndTryAndReceivePreviouslySentMessage() throws Exception {
        String addressName = "test-address";
        String prefixedName = "multicast://test-address";
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setContainerId(this.getContainerID());
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createDurableReceiver("multicast://test-address", this.getSubscriptionName());
        receiver.detach();
        AddressQueryResult address = this.getProxyToAddress("test-address");
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals(Set.of(RoutingType.MULTICAST), (Object)address.getRoutingTypes());
        Assertions.assertEquals((long)0L, (long)this.lookupSubscriptionQueue().getMessageCount());
        AmqpSender sender = session.createSender("test-address");
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg:1");
        message.setText("Test-Message");
        sender.send(message);
        Assertions.assertEquals((long)1L, (long)this.lookupSubscriptionQueue().getMessageCount());
        receiver = session.createDurableReceiver("multicast://test-address", this.getSubscriptionName());
        receiver.flow(1);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)1, (int)this.lookupSubscriptionQueue().getDeliveringCount());
        sender.close();
        receiver.close();
        connection.close();
    }

    private String getContainerID() {
        return "myContainerID";
    }

    private String getSubscriptionName() {
        return "mySubscription";
    }

    private Queue lookupSubscriptionQueue() {
        Binding binding = this.server.getPostOffice().getBinding(SimpleString.of((String)(this.getContainerID() + "." + this.getSubscriptionName())));
        if (binding != null && binding instanceof LocalQueueBinding) {
            return ((LocalQueueBinding)binding).getQueue();
        }
        throw new AssertionError((Object)"Should have found an existing queue binding for the durable subscription");
    }

    private AddressQueryResult getProxyToAddress(String addressName) throws Exception {
        return this.server.addressQuery(SimpleString.of((String)addressName));
    }
}

