/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAddressTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    private void localServer(boolean autoCreate) throws Exception {
        this.server = this.createServer(false, true);
        AddressSettings settings = new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(autoCreate)).setAutoCreateAddresses(Boolean.valueOf(autoCreate)).setAutoCreateQueues(Boolean.valueOf(autoCreate)).setAutoDeleteQueues(Boolean.valueOf(autoCreate)).setDeadLetterAddress(SimpleString.of((String)"DLQ")).setSendToDLAOnNoRoute(true);
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)"DLQ").setRoutingType(RoutingType.ANYCAST));
        this.server.getAddressSettingsRepository().addMatch(this.getName() + "*", (Object)settings);
    }

    @Test
    public void testQueueNoAutoCreateCore() throws Exception {
        this.internalQueueTest("CORE", false);
    }

    @Test
    public void testQueueNoAutoCreateAMQP() throws Exception {
        this.internalQueueTest("AMQP", false);
    }

    @Test
    public void testQueueNoAutoCreateOpenWire() throws Exception {
        this.internalQueueTest("OPENWIRE", false);
    }

    @Test
    public void testQueueAutoCreateCore() throws Exception {
        this.internalQueueTest("CORE", true);
    }

    @Test
    public void testDeletoAutoCreateAMQP() throws Exception {
        this.internalQueueTest("AMQP", true);
    }

    @Test
    public void testQueueAutoCreateOpenWire() throws Exception {
        this.internalQueueTest("OPENWIRE", true);
    }

    public void internalQueueTest(String protocol, boolean autocreate) throws Exception {
        block27: {
            this.localServer(autocreate);
            String ADDRESS_NAME = this.getName() + protocol;
            if (!autocreate) {
                this.server.addAddressInfo(new AddressInfo(ADDRESS_NAME).addRoutingType(RoutingType.ANYCAST));
                this.server.createQueue(QueueConfiguration.of((String)ADDRESS_NAME).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(false)));
            }
            ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(true, 1);
                jakarta.jms.Queue queue = session.createQueue(ADDRESS_NAME);
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.send((Message)session.createTextMessage("hello"));
                session.commit();
                connection.start();
                try (MessageConsumer consumer = session.createConsumer((Destination)queue);){
                    logger.debug("Sending hello message");
                    TextMessage message = (TextMessage)consumer.receive(5000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((Object)"hello", (Object)message.getText());
                }
                session.commit();
                Queue serverQueue = this.server.locateQueue(ADDRESS_NAME);
                Wait.assertEquals((int)0, () -> ((Queue)serverQueue).getConsumerCount());
                this.server.destroyQueue(SimpleString.of((String)ADDRESS_NAME));
                boolean exception = false;
                try {
                    logger.debug("Sending good bye message");
                    producer.send((Message)session.createTextMessage("good bye"));
                    session.commit();
                    logger.debug("Exception was not captured, sent went fine");
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    exception = true;
                }
                if (!autocreate) {
                    Assertions.assertTrue((boolean)exception);
                }
                if (autocreate) {
                    logger.debug("creating consumer");
                    try (MessageConsumer consumer = session.createConsumer((Destination)queue);){
                        TextMessage message = (TextMessage)consumer.receive(5000L);
                        Assertions.assertNotNull((Object)message);
                        Assertions.assertEquals((Object)"good bye", (Object)message.getText());
                        break block27;
                    }
                }
                exception = false;
                logger.debug("Creating consumer, where an exception is expected");
                try {
                    MessageConsumer consumer = session.createConsumer((Destination)queue);
                    if (consumer != null) {
                        consumer.close();
                    }
                }
                catch (Exception e) {
                    logger.debug("Received exception after createConsumer");
                    exception = true;
                }
                Assertions.assertTrue((boolean)exception);
            }
        }
        Queue dlqServerQueue = this.server.locateQueue("DLQ");
        Assertions.assertEquals((long)0L, (long)dlqServerQueue.getMessageCount());
    }

    @Test
    public void testTopicNoAutoCreateCore() throws Exception {
        this.internalMulticastTest("CORE", false);
    }

    @Test
    public void testTopicAutoCreateCore() throws Exception {
        this.internalMulticastTest("CORE", true);
    }

    @Test
    public void testTopicNoAutoCreateAMQP() throws Exception {
        this.internalMulticastTest("AMQP", false);
    }

    @Test
    public void testTopicAutoCreateAMQP() throws Exception {
        this.internalMulticastTest("AMQP", true);
    }

    @Test
    public void testTopicNoAutoCreateOPENWIRE() throws Exception {
        this.internalMulticastTest("OPENWIRE", false);
    }

    @Test
    public void testTopicAutoCreateOPENWIRE() throws Exception {
        this.internalMulticastTest("OPENWIRE", true);
    }

    public void internalMulticastTest(String protocol, boolean autocreate) throws Exception {
        Session session;
        this.localServer(autocreate);
        String ADDRESS_NAME = this.getName() + protocol + "_Topic";
        String dlqText = "This should be in DLQ " + RandomUtil.randomString();
        if (!autocreate) {
            this.server.addAddressInfo(new AddressInfo(ADDRESS_NAME).addRoutingType(RoutingType.MULTICAST));
        }
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            connection.setClientID("client");
            session = connection.createSession(true, 0);
            Topic destination = session.createTopic(ADDRESS_NAME);
            TopicSubscriber consumer = session.createDurableSubscriber(destination, "subs1");
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.send((Message)session.createTextMessage("hello"));
            session.commit();
            connection.start();
            logger.debug("Sending hello message");
            TextMessage message = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)"hello", (Object)message.getText());
            consumer.close();
            session.commit();
            Bindings bindings = this.server.getPostOffice().lookupBindingsForAddress(SimpleString.of((String)ADDRESS_NAME));
            for (Binding b : bindings.getBindings()) {
                if (!(b instanceof LocalQueueBinding)) continue;
                Wait.assertEquals((int)0, () -> ((LocalQueueBinding)b).getQueue().getConsumerCount());
                this.server.destroyQueue(b.getUniqueName());
            }
            producer.send((Message)session.createTextMessage(dlqText));
            session.commit();
            this.server.removeAddressInfo(SimpleString.of((String)ADDRESS_NAME), null);
            try {
                logger.debug("Sending good bye message");
                producer.send((Message)session.createTextMessage("good bye"));
                logger.debug("Exception was not captured, sent went fine");
                if (!autocreate) {
                    session.commit();
                    Assertions.fail((String)"Exception was expected");
                } else {
                    session.rollback();
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            logger.debug("creating consumer");
            try (TopicSubscriber newSubs = session.createDurableSubscriber(destination, "second");){
                if (!autocreate) {
                    Assertions.fail((String)"exception was expected");
                }
            }
            catch (Exception expected) {
                logger.debug(expected.getMessage(), (Throwable)expected);
            }
            Queue dlqServerQueue = this.server.locateQueue("DLQ");
            Assertions.assertEquals((long)1L, (long)dlqServerQueue.getMessageCount());
        }
        connection = factory.createConnection();
        try {
            connection.setClientID("client");
            connection.start();
            session = connection.createSession(true, 0);
            MessageConsumer dlqConsumer = session.createConsumer((Destination)session.createQueue("DLQ"));
            TextMessage dlqMessage = (TextMessage)dlqConsumer.receive(5000L);
            Assertions.assertNotNull((Object)dlqMessage);
            Assertions.assertEquals((Object)dlqText, (Object)dlqMessage.getText());
            Assertions.assertNull((Object)dlqConsumer.receiveNoWait());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

