/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class PrimaryToPrimaryFailoverTest
extends FailoverTest {
    private InVMNodeManager nodeManager0;
    private InVMNodeManager nodeManager1;
    private ClientSessionFactoryInternal sf2;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager0 = new InVMNodeManager(false);
        this.nodeManager1 = new InVMNodeManager(false);
        TransportConfiguration primaryConnector0 = this.getConnectorTransportConfiguration(true, 0);
        TransportConfiguration primaryConnector1 = this.getConnectorTransportConfiguration(true, 1);
        this.backupConfig = super.createDefaultInVMConfig(1).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true, 1)).setHAPolicyConfiguration((HAPolicyConfiguration)new ColocatedPolicyConfiguration().setRequestBackup(true).setPrimaryConfig((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).setBackupConfig((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration().setScaleDownConfiguration(new ScaleDownConfiguration().addConnector(primaryConnector1.getName())))).addConnectorConfiguration(primaryConnector0.getName(), primaryConnector0).addConnectorConfiguration(primaryConnector1.getName(), primaryConnector1).addClusterConfiguration(PrimaryToPrimaryFailoverTest.basicClusterConnectionConfig(primaryConnector1.getName(), primaryConnector0.getName()));
        this.backupServer = this.createColocatedTestableServer(this.backupConfig, (NodeManager)this.nodeManager1, (NodeManager)this.nodeManager0, 1);
        this.primaryConfig = super.createDefaultInVMConfig(0).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true, 0)).setHAPolicyConfiguration((HAPolicyConfiguration)new ColocatedPolicyConfiguration().setRequestBackup(true).setBackupRequestRetryInterval(1000L).setPrimaryConfig((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).setBackupConfig((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration().setScaleDownConfiguration(new ScaleDownConfiguration()))).addConnectorConfiguration(primaryConnector0.getName(), primaryConnector0).addConnectorConfiguration(primaryConnector1.getName(), primaryConnector1).addClusterConfiguration(PrimaryToPrimaryFailoverTest.basicClusterConnectionConfig(primaryConnector0.getName(), primaryConnector1.getName()));
        this.primaryServer = this.createColocatedTestableServer(this.primaryConfig, (NodeManager)this.nodeManager0, (NodeManager)this.nodeManager1, 0);
    }

    @Override
    protected void setPrimaryIdentity() {
        this.primaryServer.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/liveServer0");
    }

    @Override
    protected void setBackupIdentity() {
        this.backupServer.setIdentity(((Object)((Object)this)).getClass().getSimpleName() + "/liveServer1");
    }

    @Override
    protected void waitForBackup() {
        Map backupServers0 = this.primaryServer.getServer().getClusterManager().getHAManager().getBackupServers();
        Map backupServers1 = this.backupServer.getServer().getClusterManager().getHAManager().getBackupServers();
        long toWait = 10000L;
        long time = System.currentTimeMillis();
        while (backupServers0.size() != 1 || backupServers1.size() != 1) {
            if (System.currentTimeMillis() > time + 10000L) {
                Assertions.fail((String)("backup started? ( primary server0 backups = " + backupServers0.size() + " primary server1 backups = " + backupServers1.size() + ")"));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Assertions.fail((String)e.getMessage());
            }
        }
        PrimaryToPrimaryFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)backupServers0.values().iterator().next());
        PrimaryToPrimaryFailoverTest.waitForRemoteBackupSynchronization((ActiveMQServer)backupServers1.values().iterator().next());
    }

    @Override
    protected final ClientSessionFactoryInternal createSessionFactoryAndWaitForTopology(ServerLocator locator, int topologyMembers) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(topologyMembers * 2);
        locator.addClusterTopologyListener((ClusterTopologyListener)new FailoverTestBase.LatchClusterTopologyListener(countDownLatch));
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)locator.createSessionFactory();
        this.addSessionFactory((ClientSessionFactory)sf);
        Assertions.assertTrue((boolean)countDownLatch.await(5L, TimeUnit.SECONDS), (String)("topology members expected " + topologyMembers));
        PrimaryToPrimaryFailoverTest.closeSessionFactory((ClientSessionFactory)sf);
        sf = (ClientSessionFactoryInternal)locator.createSessionFactory(this.primaryServer.getServer().getNodeID().toString());
        this.addSessionFactory((ClientSessionFactory)sf);
        if (this.sf2 == null) {
            this.sf2 = (ClientSessionFactoryInternal)locator.createSessionFactory(this.backupServer.getServer().getNodeID().toString());
            ClientSession session2 = this.createSession((ClientSessionFactory)this.sf2, false, false);
            session2.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
            this.addSessionFactory((ClientSessionFactory)this.sf2);
        }
        return sf;
    }

    protected final ClientSessionFactoryInternal createSessionFactoryAndWaitForTopology(ServerLocator locator, TransportConfiguration transportConfiguration, int topologyMembers) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(topologyMembers * 2);
        locator.addClusterTopologyListener((ClusterTopologyListener)new FailoverTestBase.LatchClusterTopologyListener(countDownLatch));
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)locator.createSessionFactory(transportConfiguration);
        this.addSessionFactory((ClientSessionFactory)sf);
        Assertions.assertTrue((boolean)countDownLatch.await(5L, TimeUnit.SECONDS), (String)("topology members expected " + topologyMembers));
        PrimaryToPrimaryFailoverTest.closeSessionFactory((ClientSessionFactory)sf);
        sf = (ClientSessionFactoryInternal)locator.createSessionFactory(this.primaryServer.getServer().getNodeID().toString());
        this.addSessionFactory((ClientSessionFactory)sf);
        if (this.sf2 == null) {
            this.sf2 = (ClientSessionFactoryInternal)locator.createSessionFactory(this.backupServer.getServer().getNodeID().toString());
            ClientSession session2 = this.createSession((ClientSessionFactory)this.sf2, false, false);
            session2.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
            this.addSessionFactory((ClientSessionFactory)this.sf2);
        }
        return sf;
    }

    @Override
    protected void createClientSessionFactory() throws Exception {
        if (this.primaryServer.getServer().isStarted()) {
            this.sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
            this.sf = (ClientSessionFactoryInternal)this.locator.createSessionFactory(this.primaryServer.getServer().getNodeID().toString());
        } else {
            this.sf = (ClientSessionFactoryInternal)this.createSessionFactory(this.locator);
        }
    }

    @Override
    protected void createSessionFactory() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, this.getConnectorTransportConfiguration(true, 0), 2);
        if (this.sf2 == null) {
            this.sf2 = (ClientSessionFactoryInternal)this.locator.createSessionFactory(this.backupServer.getServer().getNodeID().toString());
            this.addSessionFactory((ClientSessionFactory)this.sf2);
            ClientSession session2 = this.createSession((ClientSessionFactory)this.sf2, false, false);
            session2.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        }
    }

    private TransportConfiguration getConnectorTransportConfiguration(boolean primary, int server) {
        return TransportConfigurationUtils.getInVMConnector(primary, server);
    }

    private TransportConfiguration getAcceptorTransportConfiguration(boolean primary, int server) {
        return TransportConfigurationUtils.getInVMAcceptor(primary, server);
    }

    @Test
    public void scaleDownDelay() throws Exception {
        this.createSessionFactory();
        ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        this.sendMessages(session, producer, 1000);
        this.crash(session);
        Queue serverQueue = this.backupServer.getServer().locateQueue(ADDRESS);
        Wait.assertEquals((long)1000L, () -> ((Queue)serverQueue).getMessageCount());
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        this.receiveDurableMessages(consumer);
        session.close();
        this.sf.close();
        Assertions.assertEquals((int)0, (int)this.sf.numSessions());
        Assertions.assertEquals((int)0, (int)this.sf.numConnections());
    }

    @Override
    @Test
    public void testFailoverOnInitialConnection() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        this.crash(new ClientSession[0]);
        ClientSession session = this.createSession((ClientSessionFactory)this.sf);
        ClientProducer producer = session.createProducer(ADDRESS);
        this.sendMessages(session, producer, 100);
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        this.receiveMessages(consumer);
        session.close();
    }

    @Override
    @Test
    public void testCreateNewFactoryAfterFailover() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        this.crash(true, session);
        session.close();
        long timeout = System.currentTimeMillis() + 5000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                this.createClientSessionFactory();
                break;
            }
            catch (Exception e) {
                Thread.sleep(100L);
            }
        }
        session = this.sendAndConsume((ClientSessionFactory)this.sf, false);
    }

    @Override
    @Test
    public void testTimeoutOnFailoverTransactionCommitTimeoutCommunication() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testFailBothRestartPrimary() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testPrimaryAndBackupBackupComesBackNewFactory() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testPrimaryAndBackupPrimaryComesBackNewFactory() {
    }

    @Override
    @Test
    @Disabled
    public void testTimeoutOnFailoverConsumeBlocked() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testFailoverMultipleSessionsWithConsumers() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testTimeoutOnFailover() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testTimeoutOnFailoverTransactionRollback() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testTimeoutOnFailoverConsume() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testTimeoutOnFailoverTransactionCommit() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testFailBack() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testFailBackPrimaryRestartsBackupIsGone() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testPrimaryAndBackupPrimaryComesBack() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testSimpleFailover() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testFailThenReceiveMoreMessagesAfterFailover2() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testWithoutUsingTheBackup() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testSimpleSendAfterFailoverDurableNonTemporary() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testCommitOccurredUnblockedAndResendNoDuplicates() throws Exception {
    }

    @Override
    @Test
    @Disabled
    public void testFailPrimaryTooSoon() throws Exception {
    }
}

