/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.HashSet;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;

public class SecurityFailoverTest
extends FailoverTest {
    protected ClientSession createSession(ClientSessionFactory sf, boolean isXA, boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws Exception {
        ClientSession session = sf.createSession("a", "b", isXA, autoCommitSends, autoCommitAcks, sf.getServerLocator().isPreAcknowledge(), ackBatchSize);
        this.addClientSession(session);
        return session;
    }

    @Override
    protected ClientSession createSession(ClientSessionFactory sf, boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws Exception {
        ClientSession session = sf.createSession("a", "b", false, autoCommitSends, autoCommitAcks, sf.getServerLocator().isPreAcknowledge(), ackBatchSize);
        this.addClientSession(session);
        return session;
    }

    @Override
    protected ClientSession createSession(ClientSessionFactory sf, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.createSession(sf, autoCommitSends, autoCommitAcks, sf.getServerLocator().getAckBatchSize());
    }

    @Override
    protected ClientSession createSession(ClientSessionFactory sf) throws Exception {
        return this.createSession(sf, true, true, sf.getServerLocator().getAckBatchSize());
    }

    @Override
    protected ClientSession createSession(ClientSessionFactory sf, boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.createSession(sf, xa, autoCommitSends, autoCommitAcks, sf.getServerLocator().getAckBatchSize());
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = new InVMNodeManager(false);
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setSecurityEnabled(true).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration()).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(SecurityFailoverTest.basicClusterConnectionConfig(backupConnector.getName(), primaryConnector.getName()));
        this.backupServer = this.createTestableServer(this.backupConfig);
        ActiveMQJAASSecurityManager securityManager = this.installSecurity(this.backupServer);
        securityManager.getConfiguration().setDefaultUser(null);
        this.primaryConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setSecurityEnabled(true).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addClusterConfiguration(SecurityFailoverTest.basicClusterConnectionConfig(primaryConnector.getName(), new String[0])).addConnectorConfiguration(primaryConnector.getName(), primaryConnector);
        this.primaryServer = this.createTestableServer(this.primaryConfig);
        this.installSecurity(this.primaryServer);
    }

    @Override
    protected void beforeRestart(TestableServer primaryServer1) {
        this.installSecurity(primaryServer1);
    }

    protected ActiveMQJAASSecurityManager installSecurity(TestableServer server) {
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getServer().getSecurityManager();
        securityManager.getConfiguration().addUser("a", "b");
        Role role = new Role("arole", true, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        server.getServer().getSecurityRepository().addMatch("#", roles);
        securityManager.getConfiguration().addRole("a", "arole");
        return securityManager;
    }
}

