/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SharedStoreDontWaitForActivationTest
extends ClusterTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    private void setupServers() throws Exception {
        this.setupBackupServer(0, 1, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupPrimaryServer(1, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupSharedStorePrimaryPolicy(0);
        this.setupSharedStorePrimaryPolicy(1);
        this.setupClusterConnection("cluster", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
    }

    private void setupSharedStorePrimaryPolicy(int node) {
        ActiveMQServer server = this.getServer(node);
        SharedStorePrimaryPolicyConfiguration primaryConfiguration = new SharedStorePrimaryPolicyConfiguration();
        primaryConfiguration.setFailoverOnServerShutdown(true);
        primaryConfiguration.setWaitForActivation(false);
        Configuration config = server.getConfiguration();
        config.setHAPolicyConfiguration((HAPolicyConfiguration)primaryConfiguration);
    }

    private boolean isNetty() {
        return true;
    }

    @Test
    public void startupPrimaryAndBackups() throws Exception {
        ActiveMQServer server0 = this.getServer(0);
        ActiveMQServer server1 = this.getServer(1);
        server0.start();
        Assertions.assertTrue((boolean)server0.waitForActivation(5L, TimeUnit.SECONDS));
        server1.start();
        Assertions.assertFalse((boolean)server1.waitForActivation(1L, TimeUnit.SECONDS));
        this.setupSessionFactory(0, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        server0.stop();
        Assertions.assertTrue((boolean)server1.waitForActivation(5L, TimeUnit.SECONDS));
        server0.start();
        Assertions.assertFalse((boolean)server0.waitForActivation(1L, TimeUnit.SECONDS));
        server1.stop();
        Assertions.assertTrue((boolean)server0.waitForActivation(5L, TimeUnit.SECONDS));
        server1.start();
        Assertions.assertFalse((boolean)server1.waitForActivation(1L, TimeUnit.SECONDS));
    }
}

