/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.io.EOFException;
import java.util.Arrays;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.MQTTException;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.codec.CONNACK;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MQTTSecurityTest
extends MQTTTestSupport {
    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testConnection() throws Exception {
        for (String version : Arrays.asList("3.1", "3.1.1")) {
            BlockingConnection connection = null;
            try {
                MQTT mqtt = this.createMQTTConnection("test-" + version, true);
                mqtt.setUserName(this.fullUser);
                mqtt.setPassword(this.fullPass);
                mqtt.setConnectAttemptsMax(1L);
                mqtt.setVersion(version);
                connection = mqtt.blockingConnection();
                connection.connect();
                BlockingConnection finalConnection = connection;
                Assertions.assertTrue((boolean)Wait.waitFor(() -> finalConnection.isConnected(), (long)5000L, (long)100L), (String)"Should be connected");
            }
            finally {
                if (connection == null || !connection.isConnected()) continue;
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testConnectionWithNullPassword() throws Exception {
        for (String version : Arrays.asList("3.1", "3.1.1")) {
            BlockingConnection connection = null;
            try {
                MQTT mqtt = this.createMQTTConnection("test-" + version, true);
                mqtt.setUserName(this.fullUser);
                mqtt.setPassword((String)null);
                mqtt.setConnectAttemptsMax(1L);
                mqtt.setVersion(version);
                connection = mqtt.blockingConnection();
                connection.connect();
                Assertions.fail((String)"Connect should fail");
            }
            catch (MQTTException e) {
                Assertions.assertEquals((Object)CONNACK.Code.CONNECTION_REFUSED_NOT_AUTHORIZED, (Object)e.connack.code());
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have caught an MQTTException");
            }
            finally {
                if (connection == null || !connection.isConnected()) continue;
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testPublishAuthorizationFailOn311WithDisconnect() throws Exception {
        String version = "3.1.1";
        BlockingConnection connection = null;
        try {
            MQTT mqtt = this.createMQTTConnection("test-" + version, true);
            mqtt.setUserName(this.noprivUser);
            mqtt.setPassword(this.noprivPass);
            mqtt.setConnectAttemptsMax(1L);
            mqtt.setVersion(version);
            connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish("foo", new byte[0], QoS.EXACTLY_ONCE, false);
            Assertions.fail((String)"Should have triggered an exception");
        }
        catch (EOFException mqtt) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Should not have caught an Exception");
        }
        finally {
            if (connection != null && connection.isConnected()) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testPublishAuthorizationFailOn311WithoutDisconnect() throws Exception {
        this.setAcceptorProperty("closeMqttConnectionOnPublishAuthorizationFailure=false");
        String version = "3.1.1";
        BlockingConnection connection = null;
        try {
            MQTT mqtt = this.createMQTTConnection("test-" + version, true);
            mqtt.setUserName(this.noprivUser);
            mqtt.setPassword(this.noprivPass);
            mqtt.setConnectAttemptsMax(1L);
            mqtt.setVersion(version);
            connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish("foo", new byte[0], QoS.EXACTLY_ONCE, false);
            Assertions.assertTrue((boolean)connection.isConnected());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Should not have caught an Exception");
        }
        finally {
            if (connection != null && connection.isConnected()) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testPublishAuthorizationFailOn31() throws Exception {
        String version = "3.1";
        BlockingConnection connection = null;
        try {
            MQTT mqtt = this.createMQTTConnection("test-" + version, true);
            mqtt.setUserName(this.noprivUser);
            mqtt.setPassword(this.noprivPass);
            mqtt.setConnectAttemptsMax(1L);
            mqtt.setVersion(version);
            connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish("foo", new byte[0], QoS.EXACTLY_ONCE, false);
            Assertions.assertTrue((boolean)connection.isConnected());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Should not have caught an Exception");
        }
        finally {
            if (connection != null && connection.isConnected()) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testSubscribeAuthorizationFail() throws Exception {
        for (String version : Arrays.asList("3.1", "3.1.1")) {
            BlockingConnection connection = null;
            try {
                MQTT mqtt = this.createMQTTConnection("test-" + version, true);
                mqtt.setUserName(this.noprivUser);
                mqtt.setPassword(this.noprivPass);
                mqtt.setConnectAttemptsMax(1L);
                mqtt.setVersion(version);
                connection = mqtt.blockingConnection();
                connection.connect();
                connection.subscribe(new Topic[]{new Topic("foo", QoS.AT_MOST_ONCE)});
                Assertions.assertTrue((boolean)connection.isConnected());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)"Should not have caught an Exception");
            }
            finally {
                if (connection == null || !connection.isConnected()) continue;
                connection.disconnect();
            }
        }
    }

    protected void setAcceptorProperty(String property) throws Exception {
        this.server.getRemotingService().getAcceptor("MQTT").stop();
        this.server.getRemotingService().createAcceptor("MQTT", "tcp://localhost:" + this.port + "?protocols=MQTT;" + property).start();
    }
}

