/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActiveMQMessageHandlerSecurityTest
extends ActiveMQRATestBase {
    @Override
    public boolean useSecurity() {
        return true;
    }

    @Test
    public void testSimpleMessageReceivedOnQueueWithSecurityFails() throws Exception {
        SecurityConfiguration emptyConfiguration = new SecurityConfiguration();
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).setConfiguration(emptyConfiguration);
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setUser("dodgyuser");
        spec.setPassword("dodgypassword");
        spec.setSetupAttempts(Integer.valueOf(0));
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Binding binding = this.server.getPostOffice().getBinding(MDBQUEUEPREFIXEDSIMPLE);
        Assertions.assertEquals((int)0, (int)((LocalQueueBinding)binding).getQueue().getConsumerCount());
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testSimpleMessageReceivedOnQueueWithSecuritySucceeds() throws Exception {
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("testuser", "testpassword");
        securityManager.getConfiguration().addRole("testuser", "arole");
        Role role = new Role("arole", false, true, false, false, false, false, false, false, false, false, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("mdbQueue", roles);
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setUser("testuser");
        spec.setPassword("testpassword");
        spec.setSetupAttempts(Integer.valueOf(0));
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Binding binding = this.server.getPostOffice().getBinding(MDBQUEUEPREFIXEDSIMPLE);
        Assertions.assertEquals((int)((LocalQueueBinding)binding).getQueue().getConsumerCount(), (int)15);
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }
}

