/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.jms.client;

import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMSExceptionHelperTest
extends ActiveMQTestBase {
    @Test
    public void testCONNECTION_TIMEDOUT() throws Exception {
        this.doConvertException(ActiveMQExceptionType.CONNECTION_TIMEDOUT, JMSException.class);
    }

    @Test
    public void testILLEGAL_STATE() throws Exception {
        this.doConvertException(ActiveMQExceptionType.ILLEGAL_STATE, IllegalStateException.class);
    }

    @Test
    public void testINTERNAL_ERROR() throws Exception {
        this.doConvertException(ActiveMQExceptionType.INTERNAL_ERROR, JMSException.class);
    }

    @Test
    public void testINVALID_FILTER_EXPRESSION() throws Exception {
        this.doConvertException(ActiveMQExceptionType.INVALID_FILTER_EXPRESSION, InvalidSelectorException.class);
    }

    @Test
    public void testNOT_CONNECTED() throws Exception {
        this.doConvertException(ActiveMQExceptionType.NOT_CONNECTED, JMSException.class);
    }

    @Test
    public void testOBJECT_CLOSED() throws Exception {
        this.doConvertException(ActiveMQExceptionType.OBJECT_CLOSED, IllegalStateException.class);
    }

    @Test
    public void testQUEUE_DOES_NOT_EXIST() throws Exception {
        this.doConvertException(ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST, InvalidDestinationException.class);
    }

    @Test
    public void testQUEUE_EXISTS() throws Exception {
        this.doConvertException(ActiveMQExceptionType.QUEUE_EXISTS, InvalidDestinationException.class);
    }

    @Test
    public void testSECURITY_EXCEPTION() throws Exception {
        this.doConvertException(ActiveMQExceptionType.SECURITY_EXCEPTION, JMSSecurityException.class);
    }

    @Test
    public void testUNSUPPORTED_PACKET() throws Exception {
        this.doConvertException(ActiveMQExceptionType.UNSUPPORTED_PACKET, IllegalStateException.class);
    }

    @Test
    public void testDefault() throws Exception {
        this.doConvertException(ActiveMQExceptionType.GENERIC_EXCEPTION, JMSException.class);
    }

    private void doConvertException(ActiveMQExceptionType errorCode, Class<? extends Throwable> expectedException) {
        ActiveMQException me = new ActiveMQException(errorCode);
        JMSException e = JMSExceptionHelper.convertFromActiveMQException((ActiveMQException)me);
        Assertions.assertNotNull((Object)((Object)e));
        Assertions.assertTrue((boolean)((Object)((Object)e)).getClass().isAssignableFrom(expectedException));
    }
}

