/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.apache.activemq.artemis.tests.unit.util.InVMNameParser;
import org.apache.activemq.artemis.tests.unit.util.NonSerializableFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InVMNamingContext
implements Context,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 385743957345L;
    protected Map<String, Object> map;
    protected NameParser parser = new InVMNameParser();
    private String nameInNamespace = "";

    public InVMNamingContext() {
        this.map = Collections.synchronizedMap(new HashMap());
    }

    public InVMNamingContext(String nameInNamespace) {
        this();
        this.nameInNamespace = nameInNamespace;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        int i = (name = this.trimSlashes(name)).indexOf("/");
        String tok = i == -1 ? name : name.substring(0, i);
        Object value = this.map.get(tok);
        if (value == null) {
            throw new NameNotFoundException("Name not found: " + tok);
        }
        if (value instanceof InVMNamingContext && i != -1) {
            return ((InVMNamingContext)value).lookup(name.substring(i));
        }
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            RefAddr refAddr = ref.get("nns");
            String key = (String)refAddr.getContent();
            return NonSerializableFactory.lookup(key);
        }
        return value;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.internalBind(name, obj, false);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.internalBind(name, obj, true);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        boolean terminal;
        int i = (name = this.trimSlashes(name)).indexOf("/");
        boolean bl = terminal = i == -1;
        if (terminal) {
            this.map.remove(name);
        } else {
            String tok = name.substring(0, i);
            InVMNamingContext c = (InVMNamingContext)this.map.get(tok);
            if (c == null) {
                throw new NameNotFoundException("Context not found: " + tok);
            }
            c.unbind(name.substring(i));
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String contextName) throws NamingException {
        if (!"".equals(contextName = this.trimSlashes(contextName)) && !".".equals(contextName)) {
            try {
                return ((InVMNamingContext)this.lookup(contextName)).listBindings("");
            }
            catch (Throwable t) {
                throw new NamingException(t.getMessage());
            }
        }
        ArrayList<Binding> l = new ArrayList<Binding>();
        Iterator<String> iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String element;
            String name = element = iterator.next();
            Object object = this.map.get(name);
            l.add(new Binding(name, object));
        }
        return new NamingEnumerationImpl<Binding>(l.iterator());
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.map.remove(this.trimSlashes(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        if (this.map.get(name = this.trimSlashes(name)) != null) {
            throw new NameAlreadyBoundException(name);
        }
        InVMNamingContext c = new InVMNamingContext(this.getNameInNamespace());
        this.map.put(name, c);
        return c;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.parser;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Hashtable<String, String> getEnvironment() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.apache.activemq.artemis.jms.tests.tools.container.InVMInitialContextFactory");
        return env;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.nameInNamespace;
    }

    private String trimSlashes(String s) {
        int i;
        for (i = 0; i != s.length() && s.charAt(i) == '/'; ++i) {
        }
        s = s.substring(i);
        for (i = s.length() - 1; i != -1 && s.charAt(i) == '/'; --i) {
        }
        return s.substring(0, i + 1);
    }

    private void internalBind(String name, Object obj, boolean rebind) throws NamingException {
        logger.debug("Binding {} obj {} rebind {}", new Object[]{name, obj, rebind});
        name = this.trimSlashes(name);
        int i = name.lastIndexOf("/");
        InVMNamingContext c = this;
        if (i != -1) {
            String path = name.substring(0, i);
            c = (InVMNamingContext)this.lookup(path);
        }
        name = name.substring(i + 1);
        if (!rebind && c.map.get(name) != null) {
            throw new NameAlreadyBoundException(name);
        }
        c.map.put(name, obj);
    }

    private class NamingEnumerationImpl<T>
    implements NamingEnumeration<T> {
        private final Iterator<T> iterator;

        NamingEnumerationImpl(Iterator<T> bindingIterator) {
            this.iterator = bindingIterator;
        }

        @Override
        public void close() throws NamingException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.iterator.hasNext();
        }

        @Override
        public T next() throws NamingException {
            return this.iterator.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }
    }
}

