/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;

public final class TransportConfigurationUtils {
    private TransportConfigurationUtils() {
    }

    public static TransportConfiguration getInVMAcceptor(boolean live) {
        return TransportConfigurationUtils.transportConfiguration(ActiveMQTestBase.INVM_ACCEPTOR_FACTORY, live);
    }

    public static TransportConfiguration getInVMConnector(boolean live) {
        return TransportConfigurationUtils.transportConfiguration(ActiveMQTestBase.INVM_CONNECTOR_FACTORY, live);
    }

    public static TransportConfiguration getInVMAcceptor(boolean live, int server) {
        return TransportConfigurationUtils.transportConfiguration(ActiveMQTestBase.INVM_ACCEPTOR_FACTORY, live, server);
    }

    public static TransportConfiguration getInVMConnector(boolean live, int server) {
        return TransportConfigurationUtils.transportConfiguration(ActiveMQTestBase.INVM_CONNECTOR_FACTORY, live, server);
    }

    public static TransportConfiguration getNettyAcceptor(boolean live, int server) {
        return TransportConfigurationUtils.transportConfiguration(ActiveMQTestBase.NETTY_ACCEPTOR_FACTORY, live, server);
    }

    public static TransportConfiguration getNettyConnector(boolean live, int server) {
        return TransportConfigurationUtils.transportConfiguration(ActiveMQTestBase.NETTY_CONNECTOR_FACTORY, live, server);
    }

    public static TransportConfiguration getInVMAcceptor(boolean live, int server, String name) {
        return TransportConfigurationUtils.transportConfiguration(ActiveMQTestBase.INVM_ACCEPTOR_FACTORY, live, server, name);
    }

    public static TransportConfiguration getInVMConnector(boolean live, int server, String name) {
        return TransportConfigurationUtils.transportConfiguration(ActiveMQTestBase.INVM_CONNECTOR_FACTORY, live, server, name);
    }

    public static TransportConfiguration getNettyAcceptor(boolean live, int server, String name) {
        return TransportConfigurationUtils.transportConfiguration(ActiveMQTestBase.NETTY_ACCEPTOR_FACTORY, live, server, name);
    }

    public static TransportConfiguration getNettyConnector(boolean live, int server, String name) {
        return TransportConfigurationUtils.transportConfiguration(ActiveMQTestBase.NETTY_CONNECTOR_FACTORY, live, server, name);
    }

    private static TransportConfiguration transportConfiguration(String classname, boolean live) {
        if (live) {
            return new TransportConfiguration(classname);
        }
        HashMap<String, Integer> server1Params = new HashMap<String, Integer>();
        server1Params.put("serverId", 1);
        return new TransportConfiguration(classname, server1Params);
    }

    private static TransportConfiguration transportConfiguration(String classname, boolean primary, int server) {
        if (classname.contains("netty")) {
            HashMap<String, Integer> serverParams = new HashMap<String, Integer>();
            Integer port = primary ? 61616 + server : 5545 + server;
            serverParams.put("port", port);
            return new TransportConfiguration(classname, serverParams);
        }
        HashMap<String, Integer> serverParams = new HashMap<String, Integer>();
        serverParams.put("serverId", primary ? server : server + 100);
        return new TransportConfiguration(classname, serverParams);
    }

    private static TransportConfiguration transportConfiguration(String classname, boolean primary, int server, String name) {
        if (classname.contains("netty")) {
            HashMap<String, Integer> serverParams = new HashMap<String, Integer>();
            Integer port = primary ? 61616 + server : 5545 + server;
            serverParams.put("port", port);
            return new TransportConfiguration(classname, serverParams, name);
        }
        HashMap<String, Integer> serverParams = new HashMap<String, Integer>();
        serverParams.put("serverId", primary ? server : server + 100);
        return new TransportConfiguration(classname, serverParams, name);
    }
}

