/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wsas;

import com.arjuna.mw.wsas.UserActivity;
import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.activity.HLS;
import com.arjuna.mw.wsas.activity.Outcome;
import com.arjuna.mw.wsas.common.GlobalId;
import com.arjuna.mw.wsas.completionstatus.CompletionStatus;
import com.arjuna.mw.wsas.completionstatus.FailureOnly;
import com.arjuna.mw.wsas.exceptions.ActiveChildException;
import com.arjuna.mw.wsas.exceptions.InvalidActivityException;
import com.arjuna.mw.wsas.exceptions.InvalidTimeoutException;
import com.arjuna.mw.wsas.exceptions.NoActivityException;
import com.arjuna.mw.wsas.exceptions.NoPermissionException;
import com.arjuna.mw.wsas.exceptions.ProtocolViolationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wsas.logging.wsasLogger;
import com.arjuna.mw.wsas.status.NoActivity;
import com.arjuna.mw.wsas.status.Status;
import com.arjuna.mwlabs.wsas.activity.ActivityHandleImple;
import com.arjuna.mwlabs.wsas.activity.ActivityHierarchyImple;
import com.arjuna.mwlabs.wsas.activity.ActivityImple;
import com.arjuna.mwlabs.wsas.activity.HLSManager;
import java.util.EmptyStackException;
import java.util.Stack;

public class UserActivityImple
implements UserActivity {
    private static ThreadLocal _threadAxData = new ThreadLocal();
    private static ThreadLocal _timeouts = new ThreadLocal();
    private static final int _defaultTimeout = 0;

    @Override
    public void start(String serviceType) throws WrongStateException, SystemException {
        try {
            this.start(serviceType, this.getTimeout());
        }
        catch (InvalidTimeoutException invalidTimeoutException) {
            // empty catch block
        }
    }

    @Override
    public void start(String serviceType, int timeout) throws WrongStateException, InvalidTimeoutException, SystemException {
        if (timeout < 0) {
            throw new InvalidTimeoutException();
        }
        if (timeout == 0) {
            timeout = this.getTimeout();
        }
        ActivityImple currentActivity = new ActivityImple(this.current(), serviceType);
        currentActivity.start(timeout);
        this.push(currentActivity);
        HLS hls = HLSManager.getHighLevelService(serviceType);
        try {
            if (hls != null) {
                hls.begun();
            }
        }
        catch (SystemException ex) {
            try {
                this.setCompletionStatus(FailureOnly.instance());
            }
            catch (Exception e) {
                wsasLogger.i18NLogger.warn_UserActivityImple_1(e);
            }
            throw ex;
        }
    }

    @Override
    public Outcome end() throws InvalidActivityException, WrongStateException, ProtocolViolationException, SystemException, NoActivityException, SystemException, NoPermissionException, ActiveChildException {
        ActivityImple currentActivity = this.current();
        if (currentActivity == null) {
            throw new NoActivityException();
        }
        Outcome res = null;
        String serviceType = currentActivity.serviceType();
        try {
            res = currentActivity.end();
        }
        catch (Exception ex) {
            wsasLogger.i18NLogger.warn_UserActivityImple_1(ex);
        }
        HLS hls = HLSManager.getHighLevelService(serviceType);
        if (hls != null) {
            try {
                hls.completed();
            }
            catch (SystemException ex) {
                wsasLogger.i18NLogger.warn_UserActivityImple_3(ex);
            }
        }
        this.pop();
        return res;
    }

    @Override
    public Outcome end(CompletionStatus cs) throws InvalidActivityException, WrongStateException, ProtocolViolationException, SystemException, NoActivityException, NoPermissionException, ActiveChildException {
        ActivityImple currentActivity = this.current();
        if (currentActivity == null) {
            throw new NoActivityException();
        }
        Outcome res = null;
        String serviceType = currentActivity.serviceType();
        try {
            res = currentActivity.end(cs);
        }
        catch (Exception ex) {
            wsasLogger.i18NLogger.warn_UserActivityImple_2(ex);
        }
        HLS hls = HLSManager.getHighLevelService(serviceType);
        if (hls != null) {
            try {
                hls.completed();
            }
            catch (SystemException ex) {
                wsasLogger.i18NLogger.warn_UserActivityImple_3(ex);
            }
        }
        this.pop();
        return res;
    }

    @Override
    public void setCompletionStatus(CompletionStatus endStatus) throws NoActivityException, WrongStateException, SystemException {
        ActivityImple curr = this.current();
        if (curr == null) {
            throw new NoActivityException();
        }
        curr.setCompletionStatus(endStatus);
    }

    @Override
    public CompletionStatus getCompletionStatus() throws NoActivityException, SystemException {
        ActivityImple curr = this.current();
        if (curr == null) {
            throw new NoActivityException();
        }
        return curr.getCompletionStatus();
    }

    @Override
    public int getTimeout() throws SystemException {
        Integer t = (Integer)_timeouts.get();
        int val = 0;
        if (t != null) {
            val = t;
        }
        return val;
    }

    @Override
    public void setTimeout(int timeout) throws InvalidTimeoutException, SystemException {
        if (timeout < 0) {
            throw new InvalidTimeoutException();
        }
        _timeouts.set(timeout);
    }

    @Override
    public Status status() throws SystemException {
        ActivityImple curr = this.current();
        if (curr == null) {
            return NoActivity.instance();
        }
        return curr.status();
    }

    @Override
    public String activityName() throws NoActivityException, SystemException {
        ActivityImple curr = this.current();
        if (curr == null) {
            throw new NoActivityException();
        }
        return curr.activityName();
    }

    @Override
    public GlobalId activityId() throws NoActivityException, SystemException {
        ActivityImple curr = this.current();
        if (curr == null) {
            throw new NoActivityException();
        }
        return curr.getGlobalId();
    }

    @Override
    public ActivityHierarchy suspend() throws SystemException {
        ActivityImple currentActivity = this.current();
        if (currentActivity == null) {
            return null;
        }
        String serviceType = currentActivity.serviceType();
        HLS hls = HLSManager.getHighLevelService(serviceType);
        if (hls != null) {
            try {
                hls.suspended();
            }
            catch (SystemException ex) {
                wsasLogger.i18NLogger.warn_UserActivityImple_4(ex);
            }
        }
        if ((currentActivity = this.purge()) != null) {
            return new ActivityHierarchyImple(currentActivity);
        }
        return null;
    }

    @Override
    public void resume(ActivityHierarchy tx) throws InvalidActivityException, SystemException {
        if (tx == null) {
            this.purge();
        } else if (tx instanceof ActivityHierarchyImple) {
            try {
                for (int i = 0; i < tx.size(); ++i) {
                    ActivityHandleImple handle = (ActivityHandleImple)tx.activity(i);
                    this.push(handle.getActivity());
                }
            }
            catch (Exception ex) {
                wsasLogger.logger.warnv((Throwable)ex, "Error on resuming activity from hierarchy {0}", (Object)tx);
                this.purge();
            }
        } else {
            throw new InvalidActivityException(wsasLogger.i18NLogger.get_UserActivityImple_51());
        }
        ActivityImple currentActivity = this.current();
        String serviceType = currentActivity.serviceType();
        HLS hls = HLSManager.getHighLevelService(serviceType);
        if (hls != null) {
            try {
                hls.resumed();
            }
            catch (SystemException ex) {
                wsasLogger.i18NLogger.warn_UserActivityImple_5(ex);
            }
        }
    }

    @Override
    public ActivityHierarchy currentActivity() throws SystemException {
        ActivityImple curr = this.current();
        if (curr != null) {
            return new ActivityHierarchyImple(curr);
        }
        return null;
    }

    @Override
    public String serviceType() throws NoActivityException, SystemException {
        ActivityImple currentActivity = this.current();
        if (currentActivity == null) {
            throw new NoActivityException();
        }
        return currentActivity.serviceType();
    }

    public final ActivityImple current() {
        Stack hier = (Stack)_threadAxData.get();
        ActivityImple currentActivity = null;
        if (hier != null) {
            try {
                currentActivity = (ActivityImple)hier.peek();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        return currentActivity;
    }

    private final void push(ActivityImple currentActivity) {
        Stack<ActivityImple> hier = (Stack<ActivityImple>)_threadAxData.get();
        if (hier == null) {
            hier = new Stack<ActivityImple>();
            _threadAxData.set(hier);
        }
        hier.push(currentActivity);
    }

    private final ActivityImple pop() {
        Stack hier = (Stack)_threadAxData.get();
        ActivityImple currentActivity = null;
        if (hier != null) {
            try {
                currentActivity = (ActivityImple)hier.pop();
                if (hier.isEmpty()) {
                    _threadAxData.set(null);
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        return currentActivity;
    }

    private final ActivityImple purge() {
        Stack hier = (Stack)_threadAxData.get();
        ActivityImple currentActivity = null;
        if (hier != null) {
            _threadAxData.set(null);
            try {
                currentActivity = (ActivityImple)hier.peek();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        return currentActivity;
    }
}

