/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.arjuna.common.CoordinatorEnvironmentBean;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowser;
import com.arjuna.ats.jbossatx.jts.TransactionManagerService;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.orbportability.internal.utils.PostInitLoader;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.as.txn.service.internal.tsr.TransactionSynchronizationRegistryWrapper;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.TransactionManagerLocator;
import org.jboss.tm.usertx.UserTransactionRegistry;
import org.omg.CORBA.ORB;
import org.wildfly.transaction.client.LocalUserTransaction;

public final class ArjunaTransactionManagerService
implements Service {
    public static final ServiceName SERVICE_NAME = TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER;
    private final Consumer<com.arjuna.ats.jbossatx.jta.TransactionManagerService> txnManagerServiceConsumer;
    private final Supplier<JBossXATerminator> xaTerminatorSupplier;
    private final Supplier<ORB> orbSupplier;
    private final Supplier<UserTransactionRegistry> userTransactionRegistrySupplier;
    private final Supplier<JTAEnvironmentBean> jtaEnvironmentBeanSupplier;
    private com.arjuna.ats.jbossatx.jta.TransactionManagerService value;
    private ObjStoreBrowser objStoreBrowser;
    private boolean transactionStatusManagerEnable;
    private boolean coordinatorEnableStatistics;
    private int coordinatorDefaultTimeout;
    private final boolean jts;

    public ArjunaTransactionManagerService(Consumer<com.arjuna.ats.jbossatx.jta.TransactionManagerService> txnManagerServiceConsumer, Supplier<JBossXATerminator> xaTerminatorSupplier, Supplier<ORB> orbSupplier, Supplier<UserTransactionRegistry> userTransactionRegistrySupplier, Supplier<JTAEnvironmentBean> jtaEnvironmentBeanSupplier, boolean coordinatorEnableStatistics, int coordinatorDefaultTimeout, boolean transactionStatusManagerEnable, boolean jts) {
        this.txnManagerServiceConsumer = txnManagerServiceConsumer;
        this.xaTerminatorSupplier = xaTerminatorSupplier;
        this.orbSupplier = orbSupplier;
        this.userTransactionRegistrySupplier = userTransactionRegistrySupplier;
        this.jtaEnvironmentBeanSupplier = jtaEnvironmentBeanSupplier;
        this.coordinatorEnableStatistics = coordinatorEnableStatistics;
        this.coordinatorDefaultTimeout = coordinatorDefaultTimeout;
        this.transactionStatusManagerEnable = transactionStatusManagerEnable;
        this.jts = jts;
    }

    public synchronized void start(StartContext context) throws StartException {
        CoordinatorEnvironmentBean coordinatorEnvironmentBean = arjPropertyManager.getCoordinatorEnvironmentBean();
        coordinatorEnvironmentBean.setEnableStatistics(this.coordinatorEnableStatistics);
        coordinatorEnvironmentBean.setDefaultTimeout(this.coordinatorDefaultTimeout);
        coordinatorEnvironmentBean.setTransactionStatusManagerEnable(this.transactionStatusManagerEnable);
        TxControl.setDefaultTimeout((int)this.coordinatorDefaultTimeout);
        this.objStoreBrowser = ObjStoreBrowser.getInstance();
        if (!this.jts) {
            com.arjuna.ats.jbossatx.jta.TransactionManagerService service = new com.arjuna.ats.jbossatx.jta.TransactionManagerService();
            LocalUserTransaction userTransaction = LocalUserTransaction.getInstance();
            this.jtaEnvironmentBeanSupplier.get().setUserTransaction((UserTransaction)userTransaction);
            service.setJbossXATerminator(this.xaTerminatorSupplier.get());
            service.setTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)new TransactionSynchronizationRegistryWrapper());
            try {
                service.create();
            }
            catch (Exception e) {
                throw TransactionLogger.ROOT_LOGGER.managerStartFailure(e, "Transaction");
            }
            service.start();
            this.value = service;
        } else {
            ORB orb = this.orbSupplier.get();
            new PostInitLoader(PostInitLoader.generateORBPropertyName((String)"com.arjuna.orbportability.orb"), (Object)orb);
            TransactionManagerService service = new TransactionManagerService();
            LocalUserTransaction userTransaction = LocalUserTransaction.getInstance();
            this.jtaEnvironmentBeanSupplier.get().setUserTransaction((UserTransaction)userTransaction);
            service.setJbossXATerminator(this.xaTerminatorSupplier.get());
            service.setTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)new TransactionSynchronizationRegistryWrapper());
            service.setPropagateFullContext(true);
            try {
                Field field = TransactionManagerLocator.class.getDeclaredField("tm");
                field.setAccessible(true);
                field.set(TransactionManagerLocator.getInstance(), this.jtaEnvironmentBeanSupplier.get().getTransactionManager());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
            try {
                service.create();
            }
            catch (Exception e) {
                throw TransactionLogger.ROOT_LOGGER.createFailed(e);
            }
            try {
                service.start(orb);
            }
            catch (Exception e) {
                throw TransactionLogger.ROOT_LOGGER.startFailure(e);
            }
            this.value = service;
        }
        try {
            this.objStoreBrowser.start();
        }
        catch (Exception e) {
            throw TransactionLogger.ROOT_LOGGER.objectStoreStartFailure(e);
        }
        this.txnManagerServiceConsumer.accept(this.value);
    }

    public void stop(StopContext context) {
        this.txnManagerServiceConsumer.accept(null);
        this.value.stop();
        this.value.destroy();
        this.objStoreBrowser.stop();
        this.value = null;
    }
}

