/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.metadata.EmbeddedMetadata;
import org.wildfly.clustering.cache.infinispan.AbstractCacheEntryMutator;
import org.wildfly.clustering.function.Consumer;

public class EmbeddedCacheEntryComputer<K, V>
extends AbstractCacheEntryMutator {
    private final Cache<K, V> cache;
    private final K key;
    private final BiFunction<Object, V, V> function;

    EmbeddedCacheEntryComputer(Cache<K, V> cache, K key, BiFunction<Object, V, V> function) {
        this.cache = cache;
        this.key = key;
        this.function = function;
    }

    public CompletionStage<Void> runAsync() {
        Duration maxIdleDuration = this.get();
        EmbeddedMetadata.Builder builder = new EmbeddedMetadata.Builder();
        if (!maxIdleDuration.isZero()) {
            long seconds = maxIdleDuration.getSeconds();
            if (maxIdleDuration.getNano() > 0) {
                ++seconds;
            }
            builder.maxIdle(seconds, TimeUnit.SECONDS);
        }
        return this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY}).computeAsync(this.key, this.function, builder.build()).thenAccept((java.util.function.Consumer)Consumer.empty());
    }
}

