/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.metadata.EmbeddedMetadata;
import org.wildfly.clustering.cache.infinispan.AbstractCacheEntryMutator;
import org.wildfly.clustering.function.Consumer;

public class EmbeddedCacheEntryMutator<K, V>
extends AbstractCacheEntryMutator {
    private final Cache<K, V> cache;
    private final K key;
    private final V value;

    EmbeddedCacheEntryMutator(Cache<K, V> cache, Map.Entry<K, V> entry) {
        this(cache, entry.getKey(), entry.getValue());
    }

    EmbeddedCacheEntryMutator(Cache<K, V> cache, K key, V value) {
        this.cache = cache;
        this.key = key;
        this.value = value;
    }

    public CompletionStage<Void> runAsync() {
        Duration maxIdleDuration = this.get();
        EmbeddedMetadata.Builder builder = new EmbeddedMetadata.Builder();
        if (!maxIdleDuration.isZero()) {
            long seconds = maxIdleDuration.getSeconds();
            if (maxIdleDuration.getNano() > 0) {
                ++seconds;
            }
            builder.maxIdle(seconds, TimeUnit.SECONDS);
        }
        return this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY}).putAsync(this.key, this.value, builder.build()).thenAccept((java.util.function.Consumer)Consumer.empty());
    }
}

