/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.support.IdMetaData;
import org.jboss.metadata.parser.ee.IdMetaDataParser;
import org.jboss.metadata.parser.servlet.AbstractVersionedMetaDataParser;
import org.jboss.metadata.parser.servlet.CookieConfigMetaDataParser;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.servlet.Version;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.SessionTrackingModeType;

public class SessionConfigMetaDataParser
extends AbstractVersionedMetaDataParser<SessionConfigMetaData> {
    public SessionConfigMetaDataParser(Version version) {
        super(version);
    }

    public SessionConfigMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        SessionConfigMetaData sessionConfig = new SessionConfigMetaData();
        IdMetaDataParser.parseAttributes((XMLStreamReader)reader, (IdMetaData)sessionConfig);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SESSION_TIMEOUT: {
                    try {
                        sessionConfig.setSessionTimeout(Integer.valueOf(SessionConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                        continue block9;
                    }
                    catch (NumberFormatException e) {
                        throw SessionConfigMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)e);
                    }
                }
                case COOKIE_CONFIG: {
                    sessionConfig.setCookieConfig(new CookieConfigMetaDataParser(this.getVersion()).parse(reader, propertyReplacer));
                    continue block9;
                }
                case TRACKING_MODE: {
                    List<SessionTrackingModeType> trackingModes = sessionConfig.getSessionTrackingModes();
                    if (trackingModes == null) {
                        trackingModes = new LinkedList<SessionTrackingModeType>();
                        sessionConfig.setSessionTrackingModes(trackingModes);
                    }
                    try {
                        trackingModes.add(SessionTrackingModeType.valueOf(SessionConfigMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                        continue block9;
                    }
                    catch (IllegalArgumentException e) {
                        throw SessionConfigMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)e);
                    }
                }
            }
            throw SessionConfigMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return sessionConfig;
    }
}

