/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.as.clustering.jgroups.subsystem.AbstractChannelResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jgroups.JChannel;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelConfiguration;
import org.wildfly.clustering.jgroups.spi.ForkChannelConfiguration;
import org.wildfly.clustering.jgroups.spi.ForkChannelFactory;
import org.wildfly.clustering.jgroups.spi.ForkChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReference;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;

public class ForkResourceDefinitionRegistrar
extends AbstractChannelResourceDefinitionRegistrar<ForkChannelConfiguration> {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ForkChannelConfiguration.SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).build();
    static final ResourceCapabilityReference<ForkChannelFactory> CHANNEL_FACTORY_REFERENCE = ResourceCapabilityReference.builder(CAPABILITY, (UnaryServiceDescriptor)ForkChannelFactory.SERVICE_DESCRIPTOR).withRequirementNameResolver((Function)UnaryCapabilityNameResolver.PARENT).build();
    private final ResourceServiceConfigurator configurator;

    ForkResourceDefinitionRegistrar(ServiceValueExecutorRegistry<JChannel> registry) {
        this(new AbstractChannelResourceDefinitionRegistrar.Configurator<ForkChannelConfiguration>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return JGroupsResourceRegistration.FORK;
            }

            @Override
            public RuntimeCapability<Void> getCapability() {
                return CAPABILITY;
            }

            @Override
            public ResourceModelResolver<ServiceDependency<ForkChannelConfiguration>> getChannelConfigurationResolver() {
                return new ResourceModelResolver<ServiceDependency<ForkChannelConfiguration>>(){

                    public ServiceDependency<ForkChannelConfiguration> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
                        return ServiceDependency.on((UnaryServiceDescriptor)ForkChannelFactory.SERVICE_DESCRIPTOR, (String)context.getCurrentAddressValue()).map((Function)new Function<ForkChannelFactory, ForkChannelConfiguration>(){

                            @Override
                            public ForkChannelConfiguration apply(final ForkChannelFactory factory) {
                                return new ForkChannelConfiguration(){

                                    public ForkChannelFactory getChannelFactory() {
                                        return factory;
                                    }
                                };
                            }
                        });
                    }
                };
            }

            @Override
            public ResourceModelResolver<ServiceDependency<ForkChannelFactoryConfiguration>> getForkChannelFactoryConfigurationResolver() {
                return new ResourceModelResolver<ServiceDependency<ForkChannelFactoryConfiguration>>(){

                    public ServiceDependency<ForkChannelFactoryConfiguration> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
                        String name = context.getCurrentAddressValue();
                        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                        Set entries = resource.getChildren(StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement().getKey());
                        final ArrayList<ServiceDependency> protocols = new ArrayList<ServiceDependency>(entries.size());
                        for (Resource.ResourceEntry entry : entries) {
                            protocols.add(ServiceDependency.on((BinaryServiceDescriptor)ProtocolConfiguration.SERVICE_DESCRIPTOR, (String)name, (String)entry.getName()));
                        }
                        final ServiceDependency channelFactory = (ServiceDependency)CHANNEL_FACTORY_REFERENCE.resolve(context, resource);
                        return new ServiceDependency<ForkChannelFactoryConfiguration>(){

                            public void accept(RequirementServiceBuilder<?> builder) {
                                channelFactory.accept(builder);
                                for (ServiceDependency protocol : protocols) {
                                    protocol.accept(builder);
                                }
                            }

                            public ForkChannelFactoryConfiguration get() {
                                return new ForkChannelFactoryConfiguration(){

                                    public JChannel getChannel() {
                                        return ((ForkChannelFactory)channelFactory.get()).getConfiguration().getChannel();
                                    }

                                    public ChannelConfiguration getChannelConfiguration() {
                                        return ((ForkChannelFactory)channelFactory.get()).getConfiguration().getChannelConfiguration();
                                    }

                                    public List<ProtocolConfiguration<? extends Protocol>> getProtocols() {
                                        return !protocols.isEmpty() ? protocols.stream().map(Supplier::get).collect(Collectors.toList()) : List.of();
                                    }
                                };
                            }
                        };
                    }
                };
            }

            @Override
            public ResourceModelResolver<PathAddress> getStackAddressResolver() {
                return new ResourceModelResolver<PathAddress>(){

                    public PathAddress resolve(OperationContext context, ModelNode model) throws OperationFailedException {
                        return context.getCurrentAddress();
                    }
                };
            }
        }, registry);
    }

    ForkResourceDefinitionRegistrar(AbstractChannelResourceDefinitionRegistrar.Configurator<ForkChannelConfiguration> configurator, ServiceValueExecutorRegistry<JChannel> channelRegistry) {
        super(configurator, channelRegistry);
        this.configurator = configurator;
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).addResourceCapabilityReference(CHANNEL_FACTORY_REFERENCE);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = super.register(parent, context);
        new ProtocolResourceDefinitionRegistrar(ResourceOperationRuntimeHandler.restartParent((ResourceOperationRuntimeHandler)ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this.configurator))).register(registration, context);
        return registration;
    }
}

