/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;

public abstract class AMQPBridgeSender
implements Closeable {
    protected static final AtomicLong LINK_SEQUENCE_ID = new AtomicLong();
    protected final AMQPBridgeManager bridgeManager;
    protected final AMQPBridgeToPolicyManager policyManager;
    protected final AMQPBridgeSenderConfiguration configuration;
    protected final AMQPBridgeSenderInfo senderInfo;
    protected final AMQPBridgePolicy policy;
    protected final AMQPConnectionContext connection;
    protected final AMQPSessionContext session;
    protected final AMQPBridgeMetrics.SenderMetrics metrics;
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected ProtonServerSenderContext senderContext;
    protected Sender protonSender;
    protected volatile boolean initialized;
    protected Consumer<AMQPBridgeSender> remoteOpenHandler;
    protected Consumer<AMQPBridgeSender> remoteCloseHandler;

    public AMQPBridgeSender(AMQPBridgeToPolicyManager policyManager, AMQPBridgeSenderConfiguration configuration, AMQPSessionContext session, AMQPBridgeSenderInfo senderInfo, AMQPBridgeMetrics.SenderMetrics metrics) {
        this.policyManager = policyManager;
        this.bridgeManager = policyManager.getBridgeManager();
        this.senderInfo = senderInfo;
        this.policy = policyManager.getPolicy();
        this.connection = session.getAMQPConnectionContext();
        this.session = session;
        this.configuration = configuration;
        this.metrics = metrics;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("A sender should only be initialized once");
        }
        this.initialized = true;
        this.connection.runLater(this::doCreateSender);
    }

    @Override
    public final synchronized void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.connection.runNow(() -> {
                if (this.senderContext != null) {
                    try {
                        this.senderContext.close(null);
                    }
                    catch (ActiveMQAMQPException activeMQAMQPException) {
                    }
                    finally {
                        this.senderContext = null;
                    }
                }
                if (this.protonSender != null) {
                    try {
                        this.protonSender.close();
                    }
                    finally {
                        this.protonSender = null;
                    }
                }
                this.connection.flush();
            });
        }
    }

    public AMQPBridgePolicy getPolicy() {
        return this.policy;
    }

    public final AMQPBridgeManager getBridgeManager() {
        return this.bridgeManager;
    }

    public AMQPBridgeToPolicyManager getPolicyManager() {
        return this.policyManager;
    }

    public final AMQPBridgeSenderInfo getSenderInfo() {
        return this.senderInfo;
    }

    public final AMQPBridgeSender setRemoteOpenHandler(Consumer<AMQPBridgeSender> handler) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set a remote open handler after the senderContext is initialized");
        }
        this.remoteCloseHandler = handler;
        return this;
    }

    public final AMQPBridgeSender setRemoteClosedHandler(Consumer<AMQPBridgeSender> handler) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set a remote close handler after the senderContext is initialized");
        }
        this.remoteCloseHandler = handler;
        return this;
    }

    protected abstract void doCreateSender();

    protected final Symbol[] getRemoteTerminusCapabilities() {
        if (this.policy.getRemoteTerminusCapabilities() != null && !this.policy.getRemoteTerminusCapabilities().isEmpty()) {
            return this.policy.getRemoteTerminusCapabilities().toArray(new Symbol[0]);
        }
        return null;
    }

    protected final boolean remoteLinkClosedInterceptor(Link link) {
        if (link == this.protonSender && link.getRemoteCondition() != null && link.getRemoteCondition().getCondition() != null) {
            Symbol errorCondition = link.getRemoteCondition().getCondition();
            if (AmqpSupport.RESOURCE_DELETED.equals(errorCondition)) {
                return true;
            }
            if (AmqpSupport.NOT_FOUND.equals(errorCondition)) {
                return true;
            }
            if (AmqpSupport.DETACH_FORCED.equals(errorCondition)) {
                return true;
            }
        }
        return false;
    }
}

