/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.JmxTarget;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.AbstractConstraintFactory;
import org.jboss.as.controller.access.constraint.AllowAllowNotConstraint;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.access.rbac.StandardRole;

public class SensitiveTargetConstraint
extends AllowAllowNotConstraint {
    public static final Factory FACTORY = new Factory();
    private static final SensitiveTargetConstraint SENSITIVE = new SensitiveTargetConstraint(true);
    private static final SensitiveTargetConstraint NOT_SENSITIVE = new SensitiveTargetConstraint(false);
    private static final SensitiveTargetConstraint ALLOWS = new SensitiveTargetConstraint(true, true);
    private static final SensitiveTargetConstraint DISALLOWS = new SensitiveTargetConstraint(false, true);

    private SensitiveTargetConstraint(boolean isSensitive) {
        super(isSensitive);
    }

    private SensitiveTargetConstraint(boolean allowsSensitive, boolean allowsNonSensitive) {
        super(allowsSensitive, allowsNonSensitive);
    }

    public static class Factory
    extends AbstractConstraintFactory {
        private final Map<SensitivityClassification.Key, SensitivityClassification> sensitivities = Collections.synchronizedMap(new HashMap());

        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            if (role == StandardRole.ADMINISTRATOR || role == StandardRole.SUPERUSER || role == StandardRole.AUDITOR && actionEffect != Action.ActionEffect.WRITE_CONFIG && actionEffect != Action.ActionEffect.WRITE_RUNTIME) {
                return ALLOWS;
            }
            return DISALLOWS;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.isSensitiveAction(action, actionEffect) || this.isSensitiveAttribute(target, actionEffect) ? SENSITIVE : NOT_SENSITIVE;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.isSensitiveAction(action, actionEffect) || this.isSensitiveResource(target, actionEffect) ? SENSITIVE : NOT_SENSITIVE;
        }

        private boolean isSensitiveAction(Action action, Action.ActionEffect effect) {
            for (AccessConstraintDefinition constraintDefinition : action.getAccessConstraints()) {
                SensitiveTargetAccessConstraintDefinition stcd;
                SensitivityClassification sensitivity;
                if (!(constraintDefinition instanceof SensitiveTargetAccessConstraintDefinition) || !(sensitivity = (stcd = (SensitiveTargetAccessConstraintDefinition)constraintDefinition).getSensitivity()).isSensitive(effect)) continue;
                return true;
            }
            return false;
        }

        private boolean isSensitiveAttribute(TargetAttribute target, Action.ActionEffect effect) {
            for (AccessConstraintDefinition constraintDefinition : target.getAccessConstraints()) {
                SensitiveTargetAccessConstraintDefinition stcd;
                SensitivityClassification sensitivity;
                if (!(constraintDefinition instanceof SensitiveTargetAccessConstraintDefinition) || !(sensitivity = (stcd = (SensitiveTargetAccessConstraintDefinition)constraintDefinition).getSensitivity()).isSensitive(effect)) continue;
                return true;
            }
            return this.isSensitiveResource(target.getTargetResource(), effect);
        }

        private boolean isSensitiveResource(TargetResource target, Action.ActionEffect effect) {
            for (AccessConstraintDefinition constraintDefinition : target.getAccessConstraints()) {
                SensitiveTargetAccessConstraintDefinition stcd;
                SensitivityClassification sensitivity;
                if (!(constraintDefinition instanceof SensitiveTargetAccessConstraintDefinition) || !(sensitivity = (stcd = (SensitiveTargetAccessConstraintDefinition)constraintDefinition).getSensitivity()).isSensitive(effect)) continue;
                return true;
            }
            return false;
        }

        public final SensitivityClassification addSensitivity(SensitivityClassification sensitivity) {
            SensitivityClassification result;
            SensitivityClassification.Key key = sensitivity.getKey();
            SensitivityClassification existing = this.sensitivities.get(key);
            if (existing == null) {
                this.sensitivities.put(key, sensitivity);
                result = sensitivity;
            } else {
                assert (existing.isCompatibleWith(sensitivity)) : "incompatible " + sensitivity.getClass().getSimpleName();
                result = existing;
            }
            return result;
        }

        public Collection<SensitivityClassification> getSensitivities() {
            return Collections.unmodifiableCollection(this.sensitivities.values());
        }

        @Override
        protected int internalCompare(AbstractConstraintFactory other) {
            return 0;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, JmxAction action, JmxTarget target) {
            return action.getImpact() == JmxAction.Impact.CLASSLOADING || target.isNonFacadeMBeansSensitive() ? SENSITIVE : NOT_SENSITIVE;
        }
    }
}

