/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.TypedQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextProviderService;
import org.hibernate.search.mapper.orm.search.query.impl.HibernateOrmSearchQueryAdapter;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.impl.DelegatingSearchSession;

public final class Search {
    private Search() {
    }

    public static SearchMapping mapping(SessionFactory sessionFactory) {
        SessionFactoryImplementor sessionFactoryImpl = HibernateOrmUtils.toSessionFactoryImplementor((EntityManagerFactory)sessionFactory);
        return Search.getSearchMapping(sessionFactoryImpl);
    }

    public static SearchMapping mapping(EntityManagerFactory entityManagerFactory) {
        SessionFactoryImplementor sessionFactoryImpl = HibernateOrmUtils.toSessionFactoryImplementor(entityManagerFactory);
        return Search.getSearchMapping(sessionFactoryImpl);
    }

    public static SearchSession session(Session session) {
        return Search.createSearchSession(session);
    }

    public static SearchSession session(EntityManager entityManager) {
        Session session = HibernateOrmUtils.toSession(entityManager);
        return Search.createSearchSession(session);
    }

    public static <H> TypedQuery<H> toJpaQuery(SearchQuery<H> searchQuery) {
        return HibernateOrmSearchQueryAdapter.create(searchQuery);
    }

    public static <H> Query<H> toOrmQuery(SearchQuery<H> searchQuery) {
        return HibernateOrmSearchQueryAdapter.create(searchQuery);
    }

    private static SearchMapping getSearchMapping(SessionFactoryImplementor sessionFactoryImplementor) {
        HibernateSearchContextProviderService mappingContextProvider = HibernateSearchContextProviderService.get(sessionFactoryImplementor);
        return mappingContextProvider.get();
    }

    private static SearchSession createSearchSession(Session session) {
        HibernateSearchContextProviderService mappingContextProvider = HibernateSearchContextProviderService.get(HibernateOrmUtils.toSessionFactoryImplementor((EntityManagerFactory)session.getSessionFactory()));
        return new DelegatingSearchSession(mappingContextProvider, session);
    }
}

