/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.routing.infinispan;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.deployment.DeploymentConfiguration;
import org.wildfly.clustering.server.infinispan.affinity.UnaryGroupMemberAffinity;
import org.wildfly.clustering.server.infinispan.registry.CacheContainerRegistry;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.session.cache.affinity.SessionAffinityRegistryGroupMemberMapper;
import org.wildfly.clustering.session.cache.affinity.UnarySessionAffinity;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.extension.clustering.web.routing.LocalRouteLocatorProvider;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class PrimaryOwnerRouteLocatorProvider
extends LocalRouteLocatorProvider {
    @Override
    public ServiceInstaller getServiceInstaller(DeploymentPhaseContext context, final BinaryServiceConfiguration configuration, final DeploymentConfiguration deployment) {
        final ServiceInstaller localInstaller = super.getServiceInstaller(context, configuration, deployment);
        final ServiceDependency cacheConfiguration = configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONFIGURATION);
        return (ServiceInstaller)((ServiceInstaller.Builder)ServiceInstaller.builder((ServiceInstaller)new ServiceInstaller(){

            public ServiceController<?> install(RequirementServiceTarget target) {
                if (!((Configuration)cacheConfiguration.get()).clustering().cacheMode().isClustered()) {
                    return localInstaller.install((ServiceTarget)target);
                }
                final ServiceDependency cache = configuration.withChildName(deployment.getDeploymentName()).getServiceDependency(InfinispanServiceDescriptor.CACHE).map(Cache.class::cast);
                final ServiceDependency registry = configuration.withChildName(deployment.getServerName()).getServiceDependency(ClusteringServiceDescriptor.REGISTRY).map(CacheContainerRegistry.class::cast);
                Supplier<UnaryOperator<String>> factory = new Supplier<UnaryOperator<String>>(){

                    @Override
                    public UnaryOperator<String> get() {
                        UnaryGroupMemberAffinity affinity = new UnaryGroupMemberAffinity((Cache)cache.get(), ((CacheContainerRegistry)registry.get()).getGroup());
                        return new UnarySessionAffinity((Function)affinity, (Function)new SessionAffinityRegistryGroupMemberMapper((Registry)registry.get()));
                    }
                };
                return ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)RouteLocatorProvider.builder((Supplier)factory, (DeploymentConfiguration)deployment).requires(List.of(cache, registry))).build()).install((ServiceTarget)target);
            }
        }, (CapabilityServiceSupport)((CapabilityServiceSupport)context.getDeploymentUnit().getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT))).requires((Consumer)cacheConfiguration)).build();
    }
}

