/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Objects;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class ConvertedBasicArrayType<T, S, E>
extends AbstractSingleColumnStandardBasicType<T>
implements AdjustableBasicType<T>,
BasicPluralType<T, E> {
    private final BasicType<E> baseDescriptor;
    private final String name;
    private final BasicValueConverter<T, S> converter;
    private final ValueExtractor<T> jdbcValueExtractor;
    private final ValueBinder<T> jdbcValueBinder;
    private final JdbcLiteralFormatter<T> jdbcLiteralFormatter;

    public ConvertedBasicArrayType(BasicType<E> baseDescriptor, JdbcType arrayJdbcType, JavaType<T> arrayTypeDescriptor, BasicValueConverter<T, S> converter) {
        super(arrayJdbcType, arrayTypeDescriptor);
        this.converter = converter;
        this.jdbcValueBinder = arrayJdbcType.getBinder(converter.getRelationalJavaType());
        this.jdbcValueExtractor = arrayJdbcType.getExtractor(converter.getRelationalJavaType());
        this.jdbcLiteralFormatter = arrayJdbcType.getJdbcLiteralFormatter(converter.getRelationalJavaType());
        this.baseDescriptor = baseDescriptor;
        this.name = baseDescriptor.getName() + "[]";
    }

    @Override
    public BasicType<E> getElementType() {
        return this.baseDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<X> domainJtd) {
        return this;
    }

    @Override
    public BasicValueConverter<T, ?> getValueConverter() {
        return this.converter;
    }

    @Override
    public JavaType<?> getJdbcJavaType() {
        return this.converter.getRelationalJavaType();
    }

    @Override
    public ValueExtractor<T> getJdbcValueExtractor() {
        return this.jdbcValueExtractor;
    }

    @Override
    public ValueBinder<T> getJdbcValueBinder() {
        return this.jdbcValueBinder;
    }

    @Override
    public JdbcLiteralFormatter<T> getJdbcLiteralFormatter() {
        return this.jdbcLiteralFormatter;
    }

    public boolean equals(Object o) {
        return o == this || super.equals(o) && o instanceof ConvertedBasicArrayType && Objects.equals(this.converter, ((ConvertedBasicArrayType)o).converter);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.converter.hashCode();
        return result;
    }
}

