/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.logging;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Collection;
import java.util.zip.ZipException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.wildfly.installationmanager.ManifestVersion;

@MessageLogger(projectCode="WFLYIM", length=4)
public interface InstMgrLogger
extends BasicLogger {
    public static final InstMgrLogger ROOT_LOGGER = (InstMgrLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), InstMgrLogger.class, (String)"org.wildfly.core.installationmanager");

    @Message(id=1, value="There is an installation prepared and ready to be applied. The current prepared installation can be discarded by using the 'clean' operation.")
    public OperationFailedException serverAlreadyPrepared();

    @Message(id=2, value="Invalid status change found for the artifact: '%s'")
    public RuntimeException unexpectedArtifactChange(String var1);

    @Message(id=3, value="Invalid status change found for the configuration change: '%s'")
    public RuntimeException unexpectedConfigurationChange(String var1);

    @Message(id=4, value="Channel name is mandatory.")
    public OperationFailedException missingChannelName();

    @Message(id=5, value="No repositories have been defined in the '%s' channel.")
    public OperationFailedException noChannelRepositoriesDefined(String var1);

    @Message(id=6, value="The '%s' repository in the channel does not have its URL defined.")
    public OperationFailedException noChannelRepositoryURLDefined(String var1);

    @Message(id=7, value="The repository URL '%s' for '%s' channel is invalid.")
    public OperationFailedException invalidChannelRepositoryURL(String var1, String var2);

    @Message(id=8, value="The '%s' repository in the channel does not have its ID defined.")
    public OperationFailedException noChannelRepositoryIDDefined(String var1);

    @Message(id=9, value="The manifest GAV coordinate '%s' for '%s' channel is invalid.")
    public OperationFailedException invalidChannelManifestGAV(String var1, String var2);

    @Message(id=10, value="The manifest URL '%s' for '%s' channel is invalid.")
    public OperationFailedException invalidChannelManifestURL(String var1, String var2);

    @Message(id=11, value="You cannot use the 'local-cache' option when the 'no-resolve-local-cache' option is enabled.")
    public OperationFailedException localCacheWithNoResolveLocalCache();

    @Message(id=12, value="You cannot use the 'maven-repo-file' option with the 'repositories' option because they are mutually exclusive.")
    public OperationFailedException mavenRepoFileWithRepositories();

    @Message(id=13, value="Invalid format for the repository URL: '%s'")
    public OperationFailedException invalidRepositoryURL(String var1);

    @Message(id=14, value="You cannot use the 'work-dir' option with the 'repositories' or 'maven-repo-file' options because they are mutually exclusive.")
    public OperationFailedException workDirWithMavenRepoFileOrRepositories();

    @Message(id=15, value="Channel with name '%s' cannot be found.")
    public OperationFailedException channelNameNotFound(String var1);

    @Message(id=16, value="The manifest maven coordinates for '%s' are invalid. The expected maven coordinates for this manifest are GA (GroupId:ArtifactId).")
    public OperationFailedException invalidManifestGAOnly(String var1);

    @Message(id=17, value="The manifest maven coordinates for '%s' are invalid. The expected maven coordinates for this manifest are GAV (GroupId:ArtifactId:Version) where Version is optional.")
    public OperationFailedException invalidManifestGAV(String var1);

    @Message(id=18, value="Installation Manager Service is down.")
    public IllegalStateException installationManagerServiceDown();

    @Message(id=19, value="Operation has been cancelled.")
    public OperationFailedException operationCancelled();

    @Message(id=20, value="No custom patches installed found for the specified manifest maven coordinates: '%s'")
    public OperationFailedException noCustomPatchFound(String var1);

    @Message(id=21, value="You cannot use the 'local-cache' option when the 'use-default-local-cache' option is enabled.")
    public OperationFailedException localCacheWithUseDefaultLocalCache();

    @Message(id=22, value="'no-resolve-local-cache' and 'use-default-local-cache' are mutually exclusive (specify only one).")
    public OperationFailedException noResolveLocalCacheWithUseDefaultLocalCache();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=23, value="Installation was provisioned using the following channel versions: '%s'")
    public void provisioningChannels(Collection<ManifestVersion> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=24, value="Cannot report installation status. Cannot create an InstallationManager for path '%s': '%s'")
    public void failedToCreateInstallationManager(Path var1, Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25, value="Cannot report installation channels: '%s'")
    public void failedToFindInstallationChannels(Exception var1);

    @Message(id=0, value="Zip entry %s is outside of the target dir %s.")
    public ZipException zipEntryOutsideOfTarget(String var1, String var2);

    @Message(id=0, value="The structure of directories and files in the .zip file is invalid. The '%s' directory cannot be found as a second-level entry in the extracted .zip file.")
    public ZipException invalidZipEntry(String var1);
}

