/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistrar;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.context.DefaultThreadFactory;

@Listener
public class SchedulerTopologyChangeListener<K, V, SE, CE>
implements ListenerRegistrar {
    private static final System.Logger LOGGER = System.getLogger(SchedulerTopologyChangeListener.class.getName());
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(SchedulerTopologyChangeListener.class, AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return SchedulerTopologyChangeListener.class.getClassLoader();
        }
    }));
    private final Cache<K, V> cache;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(THREAD_FACTORY);
    private final AtomicReference<Future<?>> scheduleTaskFuture = new AtomicReference();
    private final Consumer<CacheStreamFilter<SE>> scheduleTask;
    private final Consumer<CacheStreamFilter<CE>> cancelTask;
    private final BlockingManager blocking;

    public SchedulerTopologyChangeListener(Cache<K, V> cache, Consumer<CacheStreamFilter<SE>> scheduleTask, Consumer<CacheStreamFilter<CE>> cancelTask) {
        this.cache = cache;
        this.scheduleTask = scheduleTask;
        this.cancelTask = cancelTask;
        this.blocking = (BlockingManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)this.cache.getCacheManager(), BlockingManager.class);
    }

    public ListenerRegistration register() {
        this.cache.addListener((Object)this);
        return () -> {
            this.cache.removeListener((Object)this);
            LOGGER.log(System.Logger.Level.DEBUG, "Shutting down thread pool for {0} scheduler topology change listener", this.cache.getName());
            this.executor.shutdownNow();
            try {
                LOGGER.log(System.Logger.Level.DEBUG, "Awaiting task termination for {0} scheduler topology change listener", this.cache.getName());
                this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LOGGER.log(System.Logger.Level.DEBUG, "{0} scheduler topology change listener shutdown complete", this.cache.getName());
        };
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<K, V> event) {
        Cache cache = event.getCache();
        Address address = cache.getCacheManager().getAddress();
        ConsistentHash oldHash = event.getWriteConsistentHashAtStart();
        Set oldSegments = oldHash.getMembers().contains(address) ? oldHash.getPrimarySegmentsForOwner(address) : Collections.emptySet();
        ConsistentHash newHash = event.getWriteConsistentHashAtEnd();
        Set newSegments = newHash.getMembers().contains(address) ? newHash.getPrimarySegmentsForOwner(address) : Collections.emptySet();
        LOGGER.log(System.Logger.Level.DEBUG, "{0} scheduler topology change listener received {1}-topology changed event: {2} -> {3}", cache.getName(), event.isPre() ? "pre" : "post", oldHash.getMembers(), newHash.getMembers());
        if (event.isPre()) {
            if (!oldSegments.isEmpty()) {
                IntSet formerlyOwnedSegments = IntSets.mutableCopyFrom((Set)oldSegments);
                formerlyOwnedSegments.removeAll(IntSets.from((Set)newSegments));
                if (!formerlyOwnedSegments.isEmpty()) {
                    Future future = this.scheduleTaskFuture.getAndSet(null);
                    if (future != null) {
                        future.cancel(true);
                    }
                    return this.blocking.runBlocking(() -> this.cancelTask.accept(CacheStreamFilter.segments((IntSet)formerlyOwnedSegments)), (Object)this.getClass().getName());
                }
            }
        } else if (!newSegments.isEmpty()) {
            Future<String> future;
            IntSet newlyOwnedSegments = IntSets.mutableCopyFrom((Set)newSegments);
            newlyOwnedSegments.removeAll(IntSets.from((Set)oldSegments));
            if (!newlyOwnedSegments.isEmpty() && (future = this.scheduleTaskFuture.getAndSet(this.executor.submit(() -> this.scheduleTask.accept(CacheStreamFilter.segments((IntSet)newlyOwnedSegments)), this.getClass().getName()))) != null) {
                future.cancel(true);
            }
        }
        return CompletableFuture.completedStage(null);
    }
}

