/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class AbstractExtendedMBean {
    private final ObjectName name;

    AbstractExtendedMBean(String name) {
        try {
            this.name = new ObjectName(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalStateException(ex);
        }
    }

    boolean isAttributeDefined(String attributeName) {
        Objects.requireNonNull(attributeName);
        try {
            for (MBeanAttributeInfo attribute : ManagementFactory.getPlatformMBeanServer().getMBeanInfo(this.name).getAttributes()) {
                if (!attributeName.equals(attribute.getName())) continue;
                return true;
            }
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException jMException) {
            // empty catch block
        }
        return false;
    }

    boolean isOperationDefined(String operationName, String[] types) {
        Objects.requireNonNull(operationName);
        Objects.requireNonNull(types);
        try {
            for (MBeanOperationInfo op : ManagementFactory.getPlatformMBeanServer().getMBeanInfo(this.name).getOperations()) {
                if (!operationName.equals(op.getName())) continue;
                ArrayList<String> signature = new ArrayList<String>();
                for (MBeanParameterInfo p : op.getSignature()) {
                    signature.add(p.getType());
                }
                List<String> receivedTypes = Arrays.asList(types);
                if (!receivedTypes.equals(signature)) continue;
                return true;
            }
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException jMException) {
            // empty catch block
        }
        return false;
    }

    Object getAttribute(String attributeName) {
        try {
            return ManagementFactory.getPlatformMBeanServer().getAttribute(this.name, attributeName);
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void setAttribute(String attributeName, Object value) {
        try {
            Attribute attribute = new Attribute(attributeName, value);
            ManagementFactory.getPlatformMBeanServer().setAttribute(this.name, attribute);
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | InvalidAttributeValueException | MBeanException | ReflectionException ex) {
            throw new IllegalStateException(ex);
        }
    }

    Object invokeOperation(String opName, Object[] values, String[] signature) {
        try {
            return ManagementFactory.getPlatformMBeanServer().invoke(this.name, opName, values, signature);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

