/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import org.infinispan.api.Experimental;
import org.infinispan.api.async.AsyncCache;
import org.infinispan.api.async.AsyncCacheEntryProcessor;
import org.infinispan.api.async.AsyncContainer;
import org.infinispan.api.async.AsyncQuery;
import org.infinispan.api.async.AsyncStreamingCache;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.events.cache.CacheEntryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;
import org.infinispan.api.common.process.CacheEntryProcessorResult;
import org.infinispan.api.common.process.CacheProcessorOptions;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.client.hotrod.HotRod;
import org.infinispan.client.hotrod.HotRodAsyncQuery;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;

@Experimental
final class HotRodAsyncCache<K, V>
implements AsyncCache<K, V> {
    private final HotRod hotrod;
    private final InternalRemoteCache<K, V> remoteCache;

    HotRodAsyncCache(HotRod hotrod, InternalRemoteCache<K, V> remoteCache) {
        this.hotrod = hotrod;
        this.remoteCache = remoteCache;
    }

    public String name() {
        return this.remoteCache.getName();
    }

    public CompletionStage<CacheConfiguration> configuration() {
        return this.remoteCache.configuration();
    }

    public AsyncContainer container() {
        return this.hotrod.async();
    }

    public CompletionStage<V> get(K key, CacheOptions options) {
        return this.remoteCache.get(key, options);
    }

    public CompletionStage<CacheEntry<K, V>> getEntry(K key, CacheOptions options) {
        return this.remoteCache.getEntry(key, options);
    }

    public CompletionStage<CacheEntry<K, V>> putIfAbsent(K key, V value, CacheWriteOptions options) {
        return this.remoteCache.putIfAbsent(key, value, options);
    }

    public CompletionStage<Boolean> setIfAbsent(K key, V value, CacheWriteOptions options) {
        return this.remoteCache.setIfAbsent(key, value, options);
    }

    public CompletionStage<CacheEntry<K, V>> put(K key, V value, CacheWriteOptions options) {
        return this.remoteCache.put(key, value, options);
    }

    public CompletionStage<Void> set(K key, V value, CacheWriteOptions options) {
        return this.remoteCache.set(key, value, options);
    }

    public CompletionStage<Boolean> replace(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return this.remoteCache.replace(key, value, version, options);
    }

    public CompletionStage<CacheEntry<K, V>> getOrReplaceEntry(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return this.remoteCache.getOrReplaceEntry(key, value, version, options);
    }

    public CompletionStage<Boolean> remove(K key, CacheOptions options) {
        return this.remoteCache.remove(key, options);
    }

    public CompletionStage<Boolean> remove(K key, CacheEntryVersion version, CacheOptions options) {
        return this.remoteCache.remove(key, version, options);
    }

    public CompletionStage<CacheEntry<K, V>> getAndRemove(K key, CacheOptions options) {
        return this.remoteCache.getAndRemove(key, options);
    }

    public Flow.Publisher<K> keys(CacheOptions options) {
        return this.remoteCache.keys(options);
    }

    public Flow.Publisher<CacheEntry<K, V>> entries(CacheOptions options) {
        return this.remoteCache.entries(options);
    }

    public CompletionStage<Void> putAll(Map<K, V> entries, CacheWriteOptions options) {
        return this.remoteCache.putAll(entries, options);
    }

    public CompletionStage<Void> putAll(Flow.Publisher<CacheEntry<K, V>> entries, CacheWriteOptions options) {
        return this.remoteCache.putAll(entries, options);
    }

    public Flow.Publisher<CacheEntry<K, V>> getAll(Set<K> keys, CacheOptions options) {
        return this.remoteCache.getAll(keys, options);
    }

    public Flow.Publisher<CacheEntry<K, V>> getAll(CacheOptions options, K ... keys) {
        return this.remoteCache.getAll(options, keys);
    }

    public Flow.Publisher<K> removeAll(Set<K> keys, CacheWriteOptions options) {
        return this.remoteCache.removeAll(keys, options);
    }

    public Flow.Publisher<K> removeAll(Flow.Publisher<K> keys, CacheWriteOptions options) {
        return this.remoteCache.removeAll(keys, options);
    }

    public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Set<K> keys, CacheWriteOptions options) {
        return this.remoteCache.getAndRemoveAll(keys, options);
    }

    public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Flow.Publisher<K> keys, CacheWriteOptions options) {
        return this.remoteCache.getAndRemoveAll(keys, options);
    }

    public CompletionStage<Long> estimateSize(CacheOptions options) {
        return this.remoteCache.estimateSize(options);
    }

    public CompletionStage<Void> clear(CacheOptions options) {
        return this.remoteCache.clear(options);
    }

    public <R> AsyncQuery<K, V, R> query(String query, CacheOptions options) {
        return new HotRodAsyncQuery();
    }

    public Flow.Publisher<CacheEntryEvent<K, V>> listen(CacheListenerOptions options, CacheEntryEventType ... types) {
        return this.remoteCache.listen(options, types);
    }

    public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> process(Set<K> keys, AsyncCacheEntryProcessor<K, V, T> processor, CacheOptions options) {
        return this.remoteCache.process(keys, processor, options);
    }

    public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> processAll(AsyncCacheEntryProcessor<K, V, T> processor, CacheProcessorOptions options) {
        return this.remoteCache.processAll(processor, options);
    }

    public AsyncStreamingCache<K> streaming() {
        throw new UnsupportedOperationException();
    }
}

