/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;

public abstract class HotRodBulkOperation<Input, Output, Op extends HotRodOperation<Output>> {
    protected final DataFormat dataFormat;
    protected final Function<Input, Op> opFunction;

    public HotRodBulkOperation(DataFormat dataFormat, Function<Input, Op> opFunction) {
        this.dataFormat = dataFormat;
        this.opFunction = opFunction;
    }

    public final CompletionStage<Output> executeOperations(Function<Object, SocketAddress> routingFunction, BiFunction<Op, SocketAddress, CompletionStage<Output>> invoker) {
        List results = Collections.synchronizedList(new ArrayList());
        AggregateCompletionStage acs = CompletionStages.aggregateCompletionStage(results);
        Map<SocketAddress, Op> map = this.gatherOperations(routingFunction);
        map.forEach((addr, op) -> acs.dependsOn(((CompletionStage)invoker.apply((Object)op, (SocketAddress)addr)).thenAccept(results::add)));
        return this.reduce(acs.freeze());
    }

    protected SocketAddress getAddressForKey(Object key, byte[] keyBytes, Function<Object, SocketAddress> routingFunction) {
        return routingFunction.apply(this.dataFormat.isObjectStorage() ? key : (Object)keyBytes);
    }

    protected abstract Map<SocketAddress, Op> gatherOperations(Function<Object, SocketAddress> var1);

    public abstract CompletionStage<Output> reduce(CompletionStage<Collection<Output>> var1);
}

