/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.List;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.IndexStartupMode;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.query.Indexer;
import org.infinispan.search.mapper.log.impl.Log;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.util.logging.LogFactory;

public final class IndexStartupRunner {
    private static final Log log = (Log)LogFactory.getLog(IndexStartupRunner.class, Log.class);

    public static void run(SearchMapping mapping, Indexer indexer, Configuration configuration) {
        IndexStartupMode startupMode = IndexStartupRunner.computeFinalMode(configuration);
        if (IndexStartupMode.PURGE.equals((Object)startupMode)) {
            mapping.scopeAll().workspace().purge();
        } else if (IndexStartupMode.REINDEX.equals((Object)startupMode)) {
            indexer.runLocal();
        }
    }

    private IndexStartupRunner() {
    }

    private static IndexStartupMode computeFinalMode(Configuration configuration) {
        IndexStartupMode startupMode = configuration.indexing().startupMode();
        DataKind dataKind = IndexStartupRunner.computeDataKind(configuration);
        boolean indexesAreVolatile = IndexStorage.LOCAL_HEAP.equals((Object)configuration.indexing().storage());
        if (DataKind.VOLATILE.equals((Object)dataKind) && !indexesAreVolatile) {
            switch (startupMode) {
                case AUTO: 
                case PURGE: 
                case REINDEX: {
                    return IndexStartupMode.PURGE;
                }
            }
            log.logIndexStartupModeMismatch("volatile", "persistent", startupMode.toString());
            return IndexStartupMode.NONE;
        }
        if (DataKind.PERSISTENT.equals((Object)dataKind) && indexesAreVolatile) {
            switch (startupMode) {
                case AUTO: 
                case REINDEX: {
                    return IndexStartupMode.REINDEX;
                }
            }
            log.logIndexStartupModeMismatch("persistent", "volatile", startupMode.toString());
            return startupMode;
        }
        if (DataKind.SHARED_STORE.equals((Object)dataKind) && !indexesAreVolatile && IndexStartupMode.AUTO.equals((Object)startupMode)) {
            return IndexStartupMode.REINDEX;
        }
        return IndexStartupMode.AUTO.equals((Object)startupMode) ? IndexStartupMode.NONE : startupMode;
    }

    private static DataKind computeDataKind(Configuration configuration) {
        List cacheStores = configuration.persistence().stores();
        if (cacheStores.isEmpty()) {
            return DataKind.VOLATILE;
        }
        boolean sharedStore = false;
        for (StoreConfiguration cacheStore : cacheStores) {
            if (cacheStore.purgeOnStartup()) continue;
            if (cacheStore.shared()) {
                sharedStore = true;
                continue;
            }
            return DataKind.PERSISTENT;
        }
        if (sharedStore) {
            return DataKind.SHARED_STORE;
        }
        return DataKind.VOLATILE;
    }

    private static enum DataKind {
        VOLATILE,
        PERSISTENT,
        SHARED_STORE;

    }
}

