/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client;

import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class ActiveMQClientLogger_impl
implements ActiveMQClientLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQClientLogger_impl(Logger logger2) {
        this.logger = logger2;
    }

    @Override
    public void errorClearingMessages(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212001: Error on clearing messages", e);
        }
    }

    @Override
    public void timeOutWaitingForProcessing(long duration) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212002: Timed out after waiting {}ms for handler to complete processing", (Object)duration);
        }
    }

    @Override
    public void unableToCloseSession(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212003: Unable to close session", e);
        }
    }

    @Override
    public void failedToConnectToServer() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212004: Failed to connect to server.");
        }
    }

    @Override
    public void failedToConnectToServer(Integer reconnectAttempts) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212005: Tried {} times to connect. Now giving up on reconnecting it.", (Object)reconnectAttempts);
        }
    }

    @Override
    public void createConnectorException(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212007: connector.create or connectorFactory.createConnector should never throw an exception, implementation is badly behaved, but we will deal with it anyway.", e);
        }
    }

    @Override
    public void factoryLeftOpen(int i, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212008: I am closing a core ClientSessionFactory you left open. Please make sure you close all ClientSessionFactories explicitly before letting them go out of scope! {}", (Object)i, (Object)e);
        }
    }

    @Override
    public void resettingSessionAfterFailure() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212009: resetting session after failure");
        }
    }

    @Override
    public void retryCreateSessionSeverStarting(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212010: Server is starting, retry to create the session {}", (Object)name);
        }
    }

    @Override
    public void commitAfterFailover() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212011: committing transaction after failover occurred, any non persistent messages may be lost");
        }
    }

    @Override
    public void failoverDuringCommit() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212012: failure occurred during commit throwing XAException");
        }
    }

    @Override
    public void failoverDuringPrepareRollingBack() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212014: failover occurred during prepare rolling back");
        }
    }

    @Override
    public void errorDuringPrepare(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212015: failover occurred during prepare rolling back", e);
        }
    }

    @Override
    public void clientSessionNotClosed(int identity, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212016: I am closing a core ClientSession you left open. Please make sure you close all ClientSessions explicitly before letting them go out of scope! {}", (Object)identity, (Object)e);
        }
    }

    @Override
    public void errorAddingPacket(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212017: error adding packet", e);
        }
    }

    @Override
    public void errorCallingCancel(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212018: error calling cancel", e);
        }
    }

    @Override
    public void errorReadingIndex(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212019: error reading index", e);
        }
    }

    @Override
    public void errorSettingIndex(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212020: error setting index", e);
        }
    }

    @Override
    public void errorReSettingIndex(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212021: error resetting index", e);
        }
    }

    @Override
    public void errorReadingCache(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212022: error reading LargeMessage file cache", e);
        }
    }

    @Override
    public void errorClosingCache(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212023: error closing LargeMessage file cache", e);
        }
    }

    @Override
    public void errorFinalisingCache(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212024: Exception during finalization for LargeMessage file cache", e);
        }
    }

    @Override
    public void errorConnectingToNodes(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212025: did not connect the cluster connection to other nodes", e);
        }
    }

    @Override
    public void timedOutWaitingForTermination() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212026: Timed out waiting for pool to terminate");
        }
    }

    @Override
    public void timedOutWaitingForScheduledPoolTermination() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212027: Timed out waiting for scheduled pool to terminate");
        }
    }

    @Override
    public void errorStartingLocator(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212028: error starting server locator", e);
        }
    }

    @Override
    public void errorSendingTopology(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212030: error sending topology", e);
        }
    }

    @Override
    public void errorSendingTopologyNodedown(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212031: error sending topology", e);
        }
    }

    @Override
    public void timedOutStoppingDiscovery() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212032: Timed out waiting to stop discovery thread");
        }
    }

    @Override
    public void errorSendingNotifOnDiscoveryStop(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212033: unable to send notification when discovery group is stopped", e);
        }
    }

    @Override
    public void multipleServersBroadcastingSameNode(String nodeId) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212034: There are more than one servers on the network broadcasting the same node id. You will see this message exactly once (per node) if a node is restarted, in which case it can be safely ignored. But if it is logged continuously it means you really do have more than one node on the same network active concurrently with the same node id. This could occur if you have a backup node active at the same time as its primary node. nodeID={}", (Object)nodeId);
        }
    }

    @Override
    public void errorReceivingPacketInDiscovery(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212035: error receiving packet in discovery", e);
        }
    }

    @Override
    public void cannotFindPacketToClear(Integer lastReceivedCommandID, Integer firstStoredCommandID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212036: Can not find packet to clear: {} last received command id first stored command id {}", (Object)lastReceivedCommandID, (Object)firstStoredCommandID);
        }
    }

    @Override
    public void connectionFailureDetected(String protocol, String remoteAddress, String message, ActiveMQExceptionType type) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212037: {} connection failure to {} has been detected: {} [code={}]", new Object[]{protocol, remoteAddress, message, type});
        }
    }

    @Override
    public void errorCallingInterceptor(Interceptor interceptor, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212038: Failure in calling interceptor: {}", (Object)interceptor, (Object)e);
        }
    }

    @Override
    public void timeoutClosingSSL() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212040: Timed out waiting for netty ssl close future to complete");
        }
    }

    @Override
    public void timeoutClosingNettyChannel() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212041: Timed out waiting for netty channel to close");
        }
    }

    @Override
    public void timeoutFlushingPacket() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212042: Timed out waiting for packet to be flushed");
        }
    }

    @Override
    public void propertyNotInteger(String propName, String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212043: Property {} must be an Integer, it is {}", (Object)propName, (Object)name);
        }
    }

    @Override
    public void propertyNotLong(String propName, String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212044: Property {} must be a Long, it is {}", (Object)propName, (Object)name);
        }
    }

    @Override
    public void propertyNotBoolean(String propName, String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212045: Property {} must be a Boolean, it is {}", (Object)propName, (Object)name);
        }
    }

    @Override
    public void noVersionOnClasspath(String classpath) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212046: Cannot find activemq-version.properties on classpath: {}", (Object)classpath);
        }
    }

    @Override
    public void jvmAllocatedMoreMemory(Long totalMemory1, Long totalMemory2) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212047: Warning: JVM allocated more data what would make results invalid {}:{}", (Object)totalMemory1, (Object)totalMemory2);
        }
    }

    @Override
    public void broadcastGroupBindErrorRetry(String hostAndPort, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212048: Random address ({}) was already in use, trying another time", (Object)hostAndPort, (Object)t);
        }
    }

    @Override
    public void ioDiscoveryError(String hostAddress, String s) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212049: Could not bind to {} ({} address); make sure your discovery group-address is of the same type as the IP stack (IPv4 or IPv6).\nIgnoring discovery group-address, but this may lead to cross talking.", (Object)hostAddress, (Object)s);
        }
    }

    @Override
    public void compressedLargeMessageError(int length, int nReadBytes) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212050: Compressed large message tried to read {} bytes from stream {}", (Object)length, (Object)nReadBytes);
        }
    }

    @Override
    public void invalidConcurrentSessionUsage(Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212051: Invalid concurrent session usage. Sessions are not supposed to be used by more than one thread concurrently.", t);
        }
    }

    @Override
    public void packetOutOfOrder(Object obj, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212052: Packet {} was answered out of sequence due to a previous server timeout and it's being ignored", obj, (Object)t);
        }
    }

    @Override
    public void confirmationWindowDisabledWarning() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212053: CompletionListener/SendAcknowledgementHandler used with confirmationWindowSize=-1. Enable confirmationWindowSize to receive acks from server!");
        }
    }

    @Override
    public void outOfCreditOnFlowControl(String address) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212054: Destination address={} is blocked. If the system is configured to block make sure you consume messages on this configuration.", (Object)address);
        }
    }

    @Override
    public void unableToCloseConsumer(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212055: Unable to close consumer", e);
        }
    }

    @Override
    public void broadcastGroupBindError(String hostAndPort) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212056: local-bind-address specified for broadcast group but no local-bind-port. Using random port for UDP Broadcast ({})", (Object)hostAndPort);
        }
    }

    @Override
    public void timeoutStreamingLargeMessage() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212057: Large Message Streaming is taking too long to flush on back pressure.");
        }
    }

    @Override
    public void unableToGetMessage(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212058: Unable to get a message.", e);
        }
    }

    @Override
    public void failedCleaningUp(String target) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212059: Failed to clean up: {} ", (Object)target);
        }
    }

    @Override
    public void unexpectedNullDataReceived() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212060: Unexpected null data received from DiscoveryEndpoint ");
        }
    }

    @Override
    public void failedForceClose(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212061: Failed to perform force close ", e);
        }
    }

    @Override
    public void failedPerformPostActionsOnMessage(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212062: Failed to perform post actions on message processing ", e);
        }
    }

    @Override
    public void unableToHandleConnectionFailure(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212063: Unable to handle connection failure ", e);
        }
    }

    @Override
    public void unableToReceiveClusterTopology(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212064: Unable to receive cluster topology ", e);
        }
    }

    @Override
    public void unableToReceiveBroadcast(String target, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212065: {} getting exception when receiving broadcasting ", (Object)target, (Object)e);
        }
    }

    @Override
    public void unableToParseValue(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212066: failed to parse int property ", e);
        }
    }

    @Override
    public void unableToGetProperty(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212067: failed to get system property ", e);
        }
    }

    @Override
    public void unableToProcessGlobalThreadPoolIn10Sec() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212068: Couldn't finish the client globalThreadPool in less than 10 seconds, interrupting it now ");
        }
    }

    @Override
    public void unableToProcessScheduledlIn10Sec() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212069: Couldn't finish the client scheduled in less than 10 seconds, interrupting it now ");
        }
    }

    @Override
    public void unableToInitVersionLoader(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212070: Unable to initialize VersionLoader ", e);
        }
    }

    @Override
    public void unableToCheckEpollAvailability(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212071: Unable to check Epoll availability ", e);
        }
    }

    @Override
    public void failedToSetChannelReadyForWriting(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212072: Failed to change channel state to ReadyForWriting ", e);
        }
    }

    @Override
    public void unableToCheckKQueueAvailability(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212073: Unable to check KQueue availability ", e);
        }
    }

    @Override
    public void unableToCheckKQueueAvailabilityNoClass() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212075: KQueue is not available, please add to the classpath or configure useKQueue=false to remove this warning");
        }
    }

    @Override
    public void unableToCheckEpollAvailabilitynoClass() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212076: Epoll is not available, please add to the classpath or configure useEpoll=false to remove this warning");
        }
    }

    @Override
    public void broadcastTimeout(int retry, int maxretry) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212077: Timed out waiting to receive initial broadcast from cluster. Retry {} of {}", (Object)retry, (Object)maxretry);
        }
    }

    @Override
    public void ignoredParameterForDownstreamFederation(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212079: The upstream connector from the downstream federation will ignore url parameter {}", (Object)name);
        }
    }

    @Override
    public void oldStoreProvider(String value) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ212080: Using legacy SSL store provider value: {}. Please use either 'keyStoreType' or 'trustStoreType' instead as appropriate.", (Object)value);
        }
    }

    @Override
    public void onMessageError(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214000: Failed to call onMessage", e);
        }
    }

    @Override
    public void failedToCleanupSession(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214001: failed to cleanup session", e);
        }
    }

    @Override
    public void failedToExecuteListener(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214002: Failed to execute failure listener", t);
        }
    }

    @Override
    public void failedToHandleFailover(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214003: Failed to handle failover", t);
        }
    }

    @Override
    public void errorCallingEnd(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214004: XA end operation failed ", t);
        }
    }

    @Override
    public void errorCallingStart(String message, Integer code) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214005: XA start operation failed {} code:{}", (Object)message, (Object)code);
        }
    }

    @Override
    public void sessionNotXA() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214006: Session is not XA");
        }
    }

    @Override
    public void receivedExceptionAsynchronously(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214007: Received exception asynchronously from server", e);
        }
    }

    @Override
    public void failedToHandlePacket(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214008: Failed to handle packet", e);
        }
    }

    @Override
    public void failedToStopDiscovery(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214009: Failed to stop discovery group", e);
        }
    }

    @Override
    public void failedToReceiveDatagramInDiscovery(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214010: Failed to receive datagram", e);
        }
    }

    @Override
    public void failedToCallListenerInDiscovery(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214011: Failed to call discovery listener", e);
        }
    }

    @Override
    public void errorDecodingPacket(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214013: Failed to decode packet", e);
        }
    }

    @Override
    public void errorCallingFailureListener(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214014: Failed to execute failure listener", e);
        }
    }

    @Override
    public void errorCallingLifeCycleListener(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214015: Failed to execute connection life cycle listener", e);
        }
    }

    @Override
    public void errorCreatingNettyConnection(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214016: Failed to create netty connection", e);
        }
    }

    @Override
    public void caughtunexpectedThrowable(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214017: Caught unexpected Throwable", t);
        }
    }

    @Override
    public void errorOnXMLTransform(Node n, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214018: Failed to invoke getTextContent() on node {}", (Object)n, (Object)t);
        }
    }

    @Override
    public void errorOnXMLTransformInvalidConf(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214019: Invalid configuration", t);
        }
    }

    @Override
    public void errorStoppingDiscoveryBroadcastEndpoint(Object endpoint, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214020: Exception happened while stopping Discovery BroadcastEndpoint {}", endpoint, (Object)t);
        }
    }

    @Override
    public void invalidCipherSuite(String validSuites) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214021: Invalid cipher suite specified. Supported cipher suites are: {}", (Object)validSuites);
        }
    }

    @Override
    public void invalidProtocol(String validProtocols) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214022: Invalid protocol specified. Supported protocols are: {}", (Object)validProtocols);
        }
    }

    @Override
    public void invalidCFType(String type, String uri) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214025: Invalid type {}, Using default connection factory at {}", (Object)type, (Object)uri);
        }
    }

    @Override
    public void failedToBind(String p1, String p2, Throwable cause) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214030: Failed to bind {}={}", p1, p2, cause);
        }
    }

    @Override
    public void disconnectOnErrorDecoding(Throwable cause) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214031: Failed to decode buffer, disconnect immediately.", cause);
        }
    }

    @Override
    public void unableToInitVersionLoaderError(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214032: Unable to initialize VersionLoader ", e);
        }
    }

    @Override
    public void unableToResolveHost(UnknownHostException e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214033: Cannot resolve host ", e);
        }
    }

    @Override
    public void negativeRefCount(String message, String count, String debugString) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ214034: {} has negative counts {}\n{}", message, count, debugString);
        }
    }

    @Override
    public void unableToProcessGlobalFlowControlThreadPoolIn10Sec() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ214035: Couldn't finish the client globalFlowControlThreadPool in less than 10 seconds, interrupting it now");
        }
    }

    @Override
    public void connectionClosureDetected(String remoteAddress, String message, ActiveMQExceptionType type) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ214036: Connection closure to {} has been detected: {} [code={}]", new Object[]{remoteAddress, message, type});
        }
    }
}

