/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jboss.msc.service.Functions;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistrationImpl;
import org.jboss.msc.service.management.ServiceContainerMXBean;
import org.jboss.msc.service.management.ServiceStatus;

final class ServiceContainerMXBeanImpl
implements ServiceContainerMXBean {
    private static final String LS = System.lineSeparator();
    private static final String DOUBLE_LS = LS.repeat(2);
    private final ConcurrentMap<ServiceName, ServiceRegistrationImpl> registry;
    private final String containerName;

    ServiceContainerMXBeanImpl(String containerName, ConcurrentMap<ServiceName, ServiceRegistrationImpl> registry) {
        this.containerName = containerName;
        this.registry = registry;
    }

    @Override
    public Set<String> queryValues() {
        Set values = this.registry.keySet();
        TreeSet<String> retVal = new TreeSet<String>();
        for (ServiceName value : values) {
            retVal.add(value.getCanonicalName());
        }
        return retVal;
    }

    @Override
    public void dumpValues() {
        this.dumpValues(System.out);
    }

    @Override
    public String dumpValuesToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpValues(out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public Set<String> queryServiceIds() {
        return this.queryServiceIds(Functions.ServiceIdIdentityFunction.INSTANCE);
    }

    @Override
    public void dumpServiceIds() {
        this.dumpServiceIds(null, Functions.ServiceIdIdentityFunction.INSTANCE, null, System.out);
    }

    @Override
    public String dumpServiceIdsToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServiceIds(null, Functions.ServiceIdIdentityFunction.INSTANCE, null, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public Set<ServiceStatus> queryServices() {
        return this.queryServices(Functions.ServiceIdentityFunction.INSTANCE);
    }

    @Override
    public void dumpServices() {
        this.dumpServices(null, Functions.ServiceIdentityFunction.INSTANCE, null, System.out);
    }

    @Override
    public String dumpServicesToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServices(null, Functions.ServiceIdentityFunction.INSTANCE, null, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public Set<ServiceStatus> queryServicesRequiringValue(String value) {
        return this.queryServices(new Functions.ServiceRequiringValueFunction(value));
    }

    @Override
    public void dumpServicesRequiringValue(String value) {
        this.dumpServices("requiring value", new Functions.ServiceRequiringValueFunction(value), value, System.out);
    }

    @Override
    public String dumpServicesRequiringValueToString(String value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServices("requiring value", new Functions.ServiceRequiringValueFunction(value), value, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public Set<String> queryServiceIdsRequiringValue(String value) {
        return this.queryServiceIds(new Functions.ServiceIdRequiringValueFunction(value));
    }

    @Override
    public void dumpServiceIdsRequiringValue(String value) {
        this.dumpServiceIds("requiring value", new Functions.ServiceIdRequiringValueFunction(value), value, System.out);
    }

    @Override
    public String dumpServiceIdsRequiringValueToString(String value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServiceIds("requiring value", new Functions.ServiceIdRequiringValueFunction(value), value, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public ServiceStatus queryServiceProvidingValue(String value) {
        Iterator<ServiceStatus> i = this.queryServices(new Functions.ServiceProvidingValueFunction(value)).iterator();
        return i.hasNext() ? i.next() : null;
    }

    @Override
    public void dumpServiceProvidingValue(String value) {
        this.dumpServices("providing value", new Functions.ServiceProvidingValueFunction(value), value, System.out);
    }

    @Override
    public String dumpServiceProvidingValueToString(String value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServices("providing value", new Functions.ServiceProvidingValueFunction(value), value, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public String queryServiceIdProvidingValue(String value) {
        Iterator<String> i = this.queryServiceIds(new Functions.ServiceIdProvidingValueFunction(value)).iterator();
        return i.hasNext() ? i.next() : null;
    }

    @Override
    public void dumpServiceIdProvidingValue(String value) {
        this.dumpServiceIds("providing value", new Functions.ServiceIdProvidingValueFunction(value), value, System.out);
    }

    @Override
    public String dumpServiceIdProvidingValueToString(String value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServiceIds("providing value", new Functions.ServiceIdProvidingValueFunction(value), value, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public Set<ServiceStatus> queryServicesMissingValue(String value) {
        return this.queryServices(new Functions.ServiceMissingValueFunction(value));
    }

    @Override
    public void dumpServicesMissingValue(String value) {
        this.dumpServices("missing value", new Functions.ServiceMissingValueFunction(value), value, System.out);
    }

    @Override
    public String dumpServicesMissingValueToString(String value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServices("missing value", new Functions.ServiceMissingValueFunction(value), value, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public Set<String> queryServiceIdsMissingValue(String value) {
        return this.queryServiceIds(new Functions.ServiceIdMissingValueFunction(value));
    }

    @Override
    public void dumpServiceIdsMissingValue(String value) {
        this.dumpServiceIds("missing value", new Functions.ServiceIdMissingValueFunction(value), value, System.out);
    }

    @Override
    public String dumpServiceIdsMissingValueToString(String value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServiceIds("missing value", new Functions.ServiceIdMissingValueFunction(value), value, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public ServiceStatus queryServiceById(String id) {
        Iterator<ServiceStatus> i = this.queryServices(new Functions.ServiceIdFunction(id)).iterator();
        return i.hasNext() ? i.next() : null;
    }

    @Override
    public void dumpServiceById(String id) {
        this.dumpServices("of id", new Functions.ServiceIdFunction(id), id, System.out);
    }

    @Override
    public String dumpServiceByIdToString(String id) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServices("of id", new Functions.ServiceIdFunction(id), id, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public Set<ServiceStatus> queryServicesByState(String state) {
        return this.queryServices(new Functions.ServiceStateFunction(state));
    }

    @Override
    public void dumpServicesByState(String state) {
        this.dumpServices("in state", new Functions.ServiceStateFunction(state), state, System.out);
    }

    @Override
    public String dumpServicesByStateToString(String state) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServices("in state", new Functions.ServiceStateFunction(state), state, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public Set<String> queryServiceIdsByState(String state) {
        return this.queryServiceIds(new Functions.ServiceIdStateFunction(state));
    }

    @Override
    public void dumpServiceIdsByState(String state) {
        this.dumpServiceIds("in state", new Functions.ServiceIdStateFunction(state), state, System.out);
    }

    @Override
    public String dumpServiceIdsByStateToString(String state) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServiceIds("in state", new Functions.ServiceIdStateFunction(state), state, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public Set<ServiceStatus> queryServicesByMode(String mode) {
        return this.queryServices(new Functions.ServiceModeFunction(mode));
    }

    @Override
    public void dumpServicesByMode(String mode) {
        this.dumpServices("in mode", new Functions.ServiceModeFunction(mode), mode, System.out);
    }

    @Override
    public String dumpServicesByModeToString(String mode) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServices("in mode", new Functions.ServiceModeFunction(mode), mode, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    @Override
    public Set<String> queryServiceIdsByMode(String mode) {
        return this.queryServiceIds(new Functions.ServiceIdModeFunction(mode));
    }

    @Override
    public void dumpServiceIdsByMode(String mode) {
        this.dumpServiceIds("in mode", new Functions.ServiceIdModeFunction(mode), mode, System.out);
    }

    @Override
    public String dumpServiceIdsByModeToString(String mode) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);
        this.dumpServiceIds("in mode", new Functions.ServiceIdModeFunction(mode), mode, out);
        return baos.toString(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpServices(String conditionDescription, Function<ServiceStatus, ServiceStatus> function, String value, PrintStream out) {
        Set<ServiceStatus> services = this.queryServices(function);
        PrintStream printStream = out;
        synchronized (printStream) {
            if (conditionDescription != null) {
                out.printf("Number of services in container \"%s\" " + conditionDescription + " \"%s\" is: %d", this.containerName, value, services.size());
                out.print(DOUBLE_LS);
            } else {
                out.printf("Number of services in container \"%s\" is: %d", this.containerName, services.size());
                out.print(DOUBLE_LS);
            }
            for (ServiceStatus service : services) {
                out.print(service);
                out.print(LS);
            }
            out.print(LS);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpValues(PrintStream out) {
        Set<String> values = this.queryValues();
        PrintStream printStream = out;
        synchronized (printStream) {
            out.printf("Number of values in container \"%s\" is: %d", this.containerName, values.size());
            out.print(DOUBLE_LS);
            for (String value : values) {
                out.print(value);
                out.print(LS);
            }
            out.print(LS);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpServiceIds(String conditionDescription, Function<ServiceStatus, String> function, String value, PrintStream out) {
        Set<String> serviceIds = this.queryServiceIds(function);
        PrintStream printStream = out;
        synchronized (printStream) {
            if (conditionDescription != null) {
                out.printf("Number of service identifiers in container \"%s\" " + conditionDescription + " \"%s\" is: %d", this.containerName, value, serviceIds.size());
                out.print(DOUBLE_LS);
            } else {
                out.printf("Number of service identifiers in container \"%s\" is: %d", this.containerName, serviceIds.size());
                out.print(DOUBLE_LS);
            }
            for (String serviceId : serviceIds) {
                out.print(serviceId);
                out.print(LS);
            }
            out.print(LS);
            out.flush();
        }
    }

    private Set<ServiceStatus> queryServices(Function<ServiceStatus, ServiceStatus> function) {
        Collection values = this.registry.values();
        TreeSet<ServiceStatus> retVal = new TreeSet<ServiceStatus>();
        for (ServiceRegistrationImpl value : values) {
            ServiceStatus service;
            ServiceControllerImpl<?> controller = value.getDependencyController();
            if (controller == null || (service = function.apply(controller.getStatus())) == null) continue;
            retVal.add(service);
        }
        return retVal;
    }

    private Set<String> queryServiceIds(Function<ServiceStatus, String> function) {
        Collection values = this.registry.values();
        TreeSet<String> retVal = new TreeSet<String>();
        for (ServiceRegistrationImpl value : values) {
            String serviceId;
            ServiceControllerImpl<?> controller = value.getDependencyController();
            if (controller == null || (serviceId = function.apply(controller.getStatus())) == null) continue;
            retVal.add(serviceId);
        }
        return retVal;
    }
}

