/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service.management;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public final class ServiceStatus
implements Serializable,
Comparable<ServiceStatus> {
    private static final long serialVersionUID = 2L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String id;
    private final String parentId;
    private final String[] childrenIds;
    private final String[] requiredValues;
    private final String[] providedValues;
    private final String[] missingValues;
    private final String mode;
    private final String state;
    private final String exception;

    @ConstructorProperties(value={"id", "parentId", "childrenIds", "requiredValues", "providedValues", "missingValues", "serviceMode", "serviceState", "startException"})
    public ServiceStatus(String id, String parentId, String[] childrenIds, String[] requiredValues, String[] providedValues, String[] missingValues, String mode, String state, String exception) {
        this.id = id;
        this.parentId = parentId;
        this.childrenIds = childrenIds != null ? childrenIds : EMPTY_STRING_ARRAY;
        this.requiredValues = requiredValues != null ? requiredValues : EMPTY_STRING_ARRAY;
        this.providedValues = providedValues != null ? providedValues : EMPTY_STRING_ARRAY;
        this.missingValues = missingValues != null ? missingValues : EMPTY_STRING_ARRAY;
        this.mode = mode;
        this.state = state;
        this.exception = exception;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String[] getChildrenIds() {
        return this.childrenIds;
    }

    public String[] getRequiredValues() {
        return this.requiredValues;
    }

    public String[] getProvidedValues() {
        return this.providedValues;
    }

    public String[] getMissingValues() {
        return this.missingValues;
    }

    public String getMode() {
        return this.mode;
    }

    public String getState() {
        return this.state;
    }

    public String getException() {
        return this.exception;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServiceStatus)) {
            return false;
        }
        ServiceStatus other = (ServiceStatus)o;
        return this.id.equals(other.id);
    }

    @Override
    public int compareTo(ServiceStatus s) {
        return this.id.compareTo(s.id);
    }

    public String toString() {
        String ls = System.lineSeparator();
        String indentation = " ".repeat(4);
        StringBuilder sb = new StringBuilder();
        sb.append("Service").append(ls);
        sb.append(indentation).append("id: ").append(this.id).append(ls);
        if (this.parentId != null) {
            sb.append(indentation).append("parent id: ").append(this.parentId).append(ls);
        }
        if (this.childrenIds.length > 0) {
            sb.append(indentation).append("children ids: ").append(ls);
            for (String childrenId : this.childrenIds) {
                sb.append(indentation).append(indentation).append(childrenId).append(ls);
            }
        }
        if (this.requiredValues.length > 0) {
            sb.append(indentation).append("requires: ").append(ls);
            for (String requiredValue : this.requiredValues) {
                sb.append(indentation).append(indentation).append(requiredValue).append(ls);
            }
        }
        if (this.providedValues.length > 0) {
            sb.append(indentation).append("provides: ").append(ls);
            for (String providedValue : this.providedValues) {
                sb.append(indentation).append(indentation).append(providedValue).append(ls);
            }
        }
        if (this.missingValues.length > 0) {
            sb.append(indentation).append("missing: ").append(ls);
            for (String missingValue : this.missingValues) {
                sb.append(indentation).append(indentation).append(missingValue).append(ls);
            }
        }
        sb.append(indentation).append("mode: ").append(this.mode).append(ls);
        sb.append(indentation).append("state: ").append(this.state).append(ls);
        if (this.exception != null && !this.exception.isEmpty()) {
            sb.append(indentation).append("exception: ").append(this.exception).append(ls);
        }
        return sb.toString();
    }
}

