/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.ApplicationTypeConstraint;
import org.jboss.as.controller.access.constraint.SensitiveTargetConstraint;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.AbstractClassificationResource;
import org.jboss.as.domain.management.access.ApplicationClassificationTypeResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityClassificationTypeResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityResourceDefinition;

public class AccessConstraintResources {
    public static final PathElement APPLICATION_PATH_ELEMENT = PathElement.pathElement((String)"constraint", (String)"application-classification");
    public static final PathElement SENSITIVITY_PATH_ELEMENT = PathElement.pathElement((String)"constraint", (String)"sensitivity-classification");
    public static final PathElement VAULT_PATH_ELEMENT = PathElement.pathElement((String)"constraint", (String)"vault-expression");
    public static final Resource VAULT_RESOURCE = SensitivityResourceDefinition.createVaultExpressionResource();
    private static volatile Map<String, Map<String, SensitivityClassification>> classifications;
    private static volatile Map<String, Map<String, ApplicationTypeConfig>> applicationTypes;

    public static Resource getApplicationConfigResource(AccessConstraintUtilizationRegistry registry) {
        return new ApplicationClassificationResource(registry);
    }

    public static Resource getSensitivityResource(AccessConstraintUtilizationRegistry registry) {
        return new SensitivityClassificationResource(registry);
    }

    private static Map<String, Map<String, SensitivityClassification>> getSensitivityClassifications() {
        Collection current = SensitiveTargetConstraint.FACTORY.getSensitivities();
        if (classifications == null || classifications.size() != current.size()) {
            TreeMap<String, Map<String, SensitivityClassification>> classificationsMap = new TreeMap<String, Map<String, SensitivityClassification>>();
            for (SensitivityClassification classification : current) {
                String type = classification.isCore() ? "core" : classification.getSubsystem();
                TreeMap<String, SensitivityClassification> byName = (TreeMap<String, SensitivityClassification>)classificationsMap.get(type);
                if (byName == null) {
                    byName = new TreeMap<String, SensitivityClassification>();
                    classificationsMap.put(type, byName);
                }
                byName.put(classification.getName(), classification);
            }
            classifications = classificationsMap;
        }
        return classifications;
    }

    private static Map<String, Map<String, ApplicationTypeConfig>> getApplicationClassifications() {
        Collection current = ApplicationTypeConstraint.FACTORY.getApplicationTypeConfigs();
        if (applicationTypes == null || applicationTypes.size() != current.size()) {
            TreeMap<String, Map<String, ApplicationTypeConfig>> classificationsMap = new TreeMap<String, Map<String, ApplicationTypeConfig>>();
            for (ApplicationTypeConfig classification : current) {
                String type = classification.isCore() ? "core" : classification.getSubsystem();
                TreeMap<String, ApplicationTypeConfig> byName = (TreeMap<String, ApplicationTypeConfig>)classificationsMap.get(type);
                if (byName == null) {
                    byName = new TreeMap<String, ApplicationTypeConfig>();
                    classificationsMap.put(type, byName);
                }
                byName.put(classification.getName(), classification);
            }
            applicationTypes = classificationsMap;
        }
        return applicationTypes;
    }

    private static class ApplicationClassificationResource
    extends AbstractClassificationResource {
        private static final Set<String> CHILD_TYPES = Collections.singleton("type");
        private final AccessConstraintUtilizationRegistry registry;

        private ApplicationClassificationResource(AccessConstraintUtilizationRegistry registry) {
            super(APPLICATION_PATH_ELEMENT);
            this.registry = registry;
        }

        public Set<String> getChildTypes() {
            return CHILD_TYPES;
        }

        @Override
        Resource.ResourceEntry getChildEntry(String type, String name) {
            Map<String, Map<String, ApplicationTypeConfig>> applicationTypes;
            Map<String, ApplicationTypeConfig> byName;
            if ("type".equals(type) && (byName = (applicationTypes = AccessConstraintResources.getApplicationClassifications()).get(name)) != null) {
                return ApplicationClassificationTypeResourceDefinition.createResource(byName, name, this.registry);
            }
            return null;
        }

        @Override
        public Set<String> getChildrenNames(String type) {
            if ("type".equals(type)) {
                Map<String, Map<String, ApplicationTypeConfig>> configs = AccessConstraintResources.getApplicationClassifications();
                return configs.keySet();
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            if ("type".equals(childType)) {
                Map<String, Map<String, ApplicationTypeConfig>> applicationTypes = AccessConstraintResources.getApplicationClassifications();
                LinkedHashSet<Resource.ResourceEntry> children = new LinkedHashSet<Resource.ResourceEntry>();
                for (Map.Entry<String, Map<String, ApplicationTypeConfig>> entry : applicationTypes.entrySet()) {
                    children.add(ApplicationClassificationTypeResourceDefinition.createResource(entry.getValue(), entry.getKey(), this.registry));
                }
                return children;
            }
            return Collections.emptySet();
        }
    }

    private static class SensitivityClassificationResource
    extends AbstractClassificationResource {
        private static final Set<String> CHILD_TYPES = Collections.singleton("type");
        private final AccessConstraintUtilizationRegistry registry;

        private SensitivityClassificationResource(AccessConstraintUtilizationRegistry registry) {
            super(SENSITIVITY_PATH_ELEMENT);
            this.registry = registry;
        }

        public Set<String> getChildTypes() {
            return CHILD_TYPES;
        }

        @Override
        Resource.ResourceEntry getChildEntry(String type, String name) {
            Map<String, Map<String, SensitivityClassification>> classifications;
            Map<String, SensitivityClassification> byName;
            if ("type".equals(type) && (byName = (classifications = AccessConstraintResources.getSensitivityClassifications()).get(name)) != null) {
                return SensitivityClassificationTypeResourceDefinition.createResource(byName, type, name, this.registry);
            }
            return null;
        }

        @Override
        public Set<String> getChildrenNames(String type) {
            if ("type".equals(type)) {
                Map<String, Map<String, SensitivityClassification>> classifications = AccessConstraintResources.getSensitivityClassifications();
                return classifications.keySet();
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            if ("type".equals(childType)) {
                Map<String, Map<String, SensitivityClassification>> classifications = AccessConstraintResources.getSensitivityClassifications();
                LinkedHashSet<Resource.ResourceEntry> children = new LinkedHashSet<Resource.ResourceEntry>();
                for (Map.Entry<String, Map<String, SensitivityClassification>> entry : classifications.entrySet()) {
                    children.add(SensitivityClassificationTypeResourceDefinition.createResource(entry.getValue(), childType, entry.getKey(), this.registry));
                }
                return children;
            }
            return Collections.emptySet();
        }
    }
}

