/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.AsyncToCompletableFutureAdapter;
import org.jboss.remoting3.Channel;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.wildfly.common.Assert;
import org.xnio.Cancellable;

class ActiveOperationImpl<T, A>
extends AsyncFutureTask<T>
implements ActiveOperation<T, A> {
    private static final Executor directExecutor = Runnable::run;
    private static final List<Cancellable> CANCEL_REQUESTED = Collections.emptyList();
    private final A attachment;
    private final Integer operationId;
    private final ActiveOperation.ResultHandler<T> resultHandler;
    private List<Cancellable> cancellables;
    private volatile Channel channel;

    ActiveOperationImpl(final Integer operationId, final A attachment, final ActiveOperation.CompletedCallback<T> callback, final AbstractMessageHandler handler) {
        super(directExecutor);
        this.operationId = operationId;
        this.attachment = attachment;
        this.addListener(new AsyncFuture.Listener<T, Object>(){

            @Override
            public void handleComplete(AsyncFuture<? extends T> asyncFuture, Object attachment) {
                try {
                    callback.completed(asyncFuture.get());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void handleFailed(AsyncFuture<? extends T> asyncFuture, Throwable cause, Object attachment) {
                if (cause instanceof Exception) {
                    callback.failed((Exception)cause);
                } else {
                    callback.failed(new RuntimeException(cause));
                }
            }

            @Override
            public void handleCancelled(AsyncFuture<? extends T> asyncFuture, Object attachment) {
                handler.removeActiveOperation(operationId);
                callback.cancelled();
                ProtocolLogger.ROOT_LOGGER.debugf("cancelled operation (%d) attachment: (%s) handler: %s.", (Object)ActiveOperationImpl.this.getOperationId(), ActiveOperationImpl.this.getAttachment(), (Object)handler);
            }
        }, null);
        this.resultHandler = new ActiveOperation.ResultHandler<T>(){

            @Override
            public boolean done(T result) {
                try {
                    boolean bl = ActiveOperationImpl.this.setResult(result);
                    return bl;
                }
                finally {
                    handler.removeActiveOperation(operationId);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean failed(Throwable t) {
                Assert.checkNotNullParam("Throwable", t);
                try {
                    boolean failed = ActiveOperationImpl.this.setFailed(t);
                    if (failed) {
                        ProtocolLogger.ROOT_LOGGER.debugf(t, "active-op (%d) failed %s", (Object)operationId, attachment);
                    }
                    boolean bl = failed;
                    return bl;
                }
                finally {
                    handler.removeActiveOperation(operationId);
                }
            }

            @Override
            public void cancel() {
                ProtocolLogger.CONNECTION_LOGGER.debugf("Operation (%d) cancelled", (Object)operationId);
                ActiveOperationImpl.this.cancel();
            }
        };
    }

    @Override
    public Integer getOperationId() {
        return this.operationId;
    }

    @Override
    public ActiveOperation.ResultHandler<T> getResultHandler() {
        return this.resultHandler;
    }

    @Override
    public A getAttachment() {
        return this.attachment;
    }

    @Override
    public AsyncFuture<T> getResult() {
        return this;
    }

    @Override
    public <U> CompletableFuture<U> getCompletableFuture(Function<T, U> transformer, Consumer<Boolean> asyncCancelTask) {
        return AsyncToCompletableFutureAdapter.adapt(this, transformer, asyncCancelTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncCancel(boolean interruptionDesired) {
        List<Cancellable> cancellables;
        ActiveOperationImpl activeOperationImpl = this;
        synchronized (activeOperationImpl) {
            cancellables = this.cancellables;
            if (cancellables == CANCEL_REQUESTED) {
                return;
            }
            this.cancellables = CANCEL_REQUESTED;
            if (cancellables == null) {
                this.setCancelled();
                return;
            }
        }
        for (Cancellable cancellable : cancellables) {
            cancellable.cancel();
        }
        this.setCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCancellable(Cancellable cancellable) {
        ActiveOperationImpl activeOperationImpl = this;
        synchronized (activeOperationImpl) {
            switch (this.getStatus()) {
                case CANCELLED: {
                    break;
                }
                case WAITING: {
                    List<Cancellable> cancellables = this.cancellables;
                    if (cancellables == CANCEL_REQUESTED) break;
                    (cancellables == null ? (this.cancellables = new ArrayList<Cancellable>()) : cancellables).add(cancellable);
                }
                default: {
                    return;
                }
            }
        }
        cancellable.cancel();
    }

    private void cancel() {
        super.cancel(true);
    }

    Channel getChannel() {
        return this.channel;
    }

    void updateChannelRef(Channel channel) {
        if (this.channel == null) {
            this.channel = channel;
        }
    }
}

