/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.server.SecurityDomain;

class ForbidAnonymousInterceptor
implements Interceptor {
    private static ForbidAnonymousInterceptor instance = new ForbidAnonymousInterceptor();

    static ForbidAnonymousInterceptor getInstance() {
        return instance;
    }

    private ForbidAnonymousInterceptor() {
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        SecurityDomain securityDomain = (SecurityDomain)context.getPrivateData(SecurityDomain.class);
        Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
        if (securityDomain.getCurrentSecurityIdentity().getPrincipal() instanceof AnonymousPrincipal) {
            throw EjbLogger.EJB3_INVOCATION_LOGGER.ejbAuthenticationRequired();
        }
        return context.proceed();
    }
}

