/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.Serializable;
import java.util.UUID;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.impl.backing.SerializationGroupImpl;
import org.jboss.as.ejb3.cache.impl.backing.SerializationGroupSerializabilityChecker;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryFactory;
import org.jboss.as.ejb3.cache.spi.PassivatingBackingCache;
import org.jboss.as.ejb3.cache.spi.ReplicationPassivationManager;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SerializabilityChecker;

public class SerializationGroupContainer<K extends Serializable, V extends Cacheable<K>>
implements BackingCacheEntryFactory<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>>,
ReplicationPassivationManager<UUID, SerializationGroup<K, V, UUID>>,
StatefulObjectFactory<Cacheable<UUID>> {
    private static final Logger log = Logger.getLogger(SerializationGroupContainer.class);
    private PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>> groupCache;
    private final PassivationManager<K, V> passivationManager;
    private final SerializationGroupSerializabilityChecker serializabilityChecker = new SerializationGroupSerializabilityChecker();
    private boolean clustered;

    public SerializationGroupContainer(PassivationManager<K, V> passivationManager) {
        this.serializabilityChecker.addSerializabilityChecker(SerializabilityChecker.DEFAULT);
        this.passivationManager = passivationManager;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.passivationManager.getClassLoader();
    }

    public int getCurrentMarshallingVersion() {
        return this.passivationManager.getCurrentMarshallingVersion();
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        MarshallingConfiguration config = this.passivationManager.getMarshallingConfiguration(version);
        MarshallingConfiguration result = new MarshallingConfiguration();
        result.setBufferSize(config.getBufferSize());
        result.setClassCount(config.getClassCount());
        result.setClassExternalizerFactory(config.getClassExternalizerFactory());
        result.setClassResolver(config.getClassResolver());
        result.setClassTable(config.getClassTable());
        result.setExceptionListener(config.getExceptionListener());
        result.setExternalizerCreator(config.getExternalizerCreator());
        result.setInstanceCount(config.getInstanceCount());
        result.setObjectResolver(config.getObjectResolver());
        result.setObjectTable(config.getObjectTable());
        result.setSerializabilityChecker((SerializabilityChecker)this.serializabilityChecker);
        result.setSerializedCreator(config.getSerializedCreator());
        result.setStreamHeader(config.getStreamHeader());
        result.setVersion(config.getVersion());
        return result;
    }

    public void addMemberPassivationManager(PassivationManager<K, V> passivationManager) {
        SerializabilityChecker checker = passivationManager.getMarshallingConfiguration(passivationManager.getCurrentMarshallingVersion()).getSerializabilityChecker();
        if (checker != null) {
            this.serializabilityChecker.addSerializabilityChecker(checker);
        }
    }

    @Override
    public Cacheable<UUID> createInstance() {
        return null;
    }

    @Override
    public void destroyInstance(Cacheable<UUID> instance) {
    }

    @Override
    public SerializationGroup<K, V, UUID> createEntry(Cacheable<UUID> item) {
        SerializationGroupImpl<K, V> group = new SerializationGroupImpl<K, V>((UUID)this.groupCache.createIdentifier());
        group.setClustered(this.clustered);
        group.setGroupCache(this.groupCache);
        return group;
    }

    @Override
    public void destroyEntry(SerializationGroup<K, V, UUID> group) {
    }

    @Override
    public void postActivate(SerializationGroup<K, V, UUID> group) {
        log.tracef("postActivate(%s)", group);
        group.setGroupCache(this.groupCache);
        group.postActivate();
    }

    @Override
    public void prePassivate(SerializationGroup<K, V, UUID> group) {
        log.tracef("prePassivate(%s)", group);
        group.prePassivate();
    }

    @Override
    public void postReplicate(SerializationGroup<K, V, UUID> group) {
        log.tracef("postReplicate(%s)", group);
        group.setGroupCache(this.groupCache);
        group.postReplicate();
    }

    @Override
    public void preReplicate(SerializationGroup<K, V, UUID> group) {
        log.tracef("preReplicate(%s)", group);
        group.preReplicate();
    }

    public PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>> getGroupCache() {
        return this.groupCache;
    }

    public void setGroupCache(PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>> groupCache) {
        this.groupCache = groupCache;
    }
}

