/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateless;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PooledComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateless.StatelessAllowedMethodsInformation;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponentCreateService;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponentInstance;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.ejb.client.Affinity;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactoryContext;

public class StatelessSessionComponent
extends SessionBeanComponent
implements PooledComponent<StatelessSessionComponentInstance> {
    private final Pool<StatelessSessionComponentInstance> pool;
    private final String poolName;
    private final Method timeoutMethod;
    private final Affinity weakAffinity;

    public StatelessSessionComponent(StatelessSessionComponentCreateService slsbComponentCreateService) {
        super(slsbComponentCreateService);
        StatelessObjectFactory<StatelessSessionComponentInstance> factory = new StatelessObjectFactory<StatelessSessionComponentInstance>(){

            @Override
            public StatelessSessionComponentInstance create() {
                return (StatelessSessionComponentInstance)StatelessSessionComponent.this.createInstance();
            }

            @Override
            public void destroy(StatelessSessionComponentInstance obj) {
                obj.destroy();
            }
        };
        PoolConfig poolConfig = slsbComponentCreateService.getPoolConfig();
        if (poolConfig == null) {
            EjbLogger.ROOT_LOGGER.debug("Pooling is disabled for Stateless EJB " + slsbComponentCreateService.getComponentName());
            this.pool = null;
            this.poolName = null;
        } else {
            EjbLogger.ROOT_LOGGER.debug("Using pool config " + poolConfig + " to create pool for Stateless EJB " + slsbComponentCreateService.getComponentName());
            this.pool = poolConfig.createPool(factory);
            this.poolName = poolConfig.getPoolName();
        }
        this.timeoutMethod = slsbComponentCreateService.getTimeoutMethod();
        this.weakAffinity = slsbComponentCreateService.getWeakAffinity();
    }

    protected BasicComponentInstance instantiateComponentInstance(AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, InterceptorFactoryContext interceptorContext) {
        return new StatelessSessionComponentInstance(this, instanceReference, preDestroyInterceptor, methodInterceptors);
    }

    @Override
    public Pool<StatelessSessionComponentInstance> getPool() {
        return this.pool;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public Affinity getWeakAffinity() {
        return this.weakAffinity;
    }

    @Override
    public void start() {
        this.getShutDownInterceptorFactory().start();
        super.start();
        if (this.pool != null) {
            this.pool.start();
        }
    }

    @Override
    public void stop() {
        this.getShutDownInterceptorFactory().shutdown();
        if (this.pool != null) {
            this.pool.stop();
        }
        super.stop();
    }

    @Override
    public AllowedMethodsInformation getAllowedMethodsInformation() {
        return this.isBeanManagedTransaction() ? StatelessAllowedMethodsInformation.INSTANCE_BMT : StatelessAllowedMethodsInformation.INSTANCE_CMT;
    }
}

