/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.lang.reflect.Method;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;

public class DeploymentDescriptorMethodProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CLASS_INDEX);
        if (eeModuleDescription != null) {
            for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
                if (!(component instanceof EJBComponentDescription)) continue;
                try {
                    if (component instanceof SessionBeanComponentDescription || component instanceof MessageDrivenComponentDescription) {
                        this.handleSessionBean((EJBComponentDescription)component, classIndex, reflectionIndex);
                    }
                    if (!(component instanceof StatelessComponentDescription) && !(component instanceof MessageDrivenComponentDescription)) continue;
                    this.handleStatelessSessionBean((EJBComponentDescription)component, classIndex, reflectionIndex);
                }
                catch (ClassNotFoundException e) {
                    throw EjbMessages.MESSAGES.failToLoadComponentClass(e, component.getComponentName());
                }
            }
        }
    }

    private void handleStatelessSessionBean(EJBComponentDescription component, DeploymentClassIndex classIndex, DeploymentReflectionIndex reflectionIndex) throws ClassNotFoundException, DeploymentUnitProcessingException {
        ClassIndex componentClass = classIndex.classIndex(component.getComponentClassName());
        MethodIdentifier ejbCreateId = MethodIdentifier.getIdentifier(Void.TYPE, (String)"ejbCreate", (Class[])new Class[0]);
        Method ejbCreate = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)reflectionIndex, (Class)componentClass.getModuleClass(), (MethodIdentifier)ejbCreateId);
        if (ejbCreate != null) {
            InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
            builder.setPostConstruct(ejbCreateId);
            component.addInterceptorMethodOverride(ejbCreate.getDeclaringClass().getName(), builder.build());
        }
        MethodIdentifier ejbRemoveId = MethodIdentifier.getIdentifier(Void.TYPE, (String)"ejbRemove", (Class[])new Class[0]);
        Method ejbRemove = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)reflectionIndex, (Class)componentClass.getModuleClass(), (MethodIdentifier)ejbRemoveId);
        if (ejbRemove != null) {
            InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
            builder.setPreDestroy(ejbRemoveId);
            component.addInterceptorMethodOverride(ejbRemove.getDeclaringClass().getName(), builder.build());
        }
    }

    private void handleSessionBean(EJBComponentDescription component, DeploymentClassIndex classIndex, DeploymentReflectionIndex reflectionIndex) throws ClassNotFoundException, DeploymentUnitProcessingException {
        LifecycleCallbacksMetaData preDestroys;
        LifecycleCallbacksMetaData postConstructs;
        if (component.getDescriptorData() == null) {
            return;
        }
        ClassIndex componentClass = classIndex.classIndex(component.getComponentClassName());
        EnterpriseBeanMetaData metaData = component.getDescriptorData();
        AroundInvokesMetaData aroundInvokes = null;
        if (metaData instanceof SessionBeanMetaData) {
            aroundInvokes = ((SessionBeanMetaData)metaData).getAroundInvokes();
        } else if (metaData instanceof MessageDrivenBeanMetaData) {
            aroundInvokes = ((MessageDrivenBeanMetaData)metaData).getAroundInvokes();
        }
        if (aroundInvokes != null) {
            for (AroundInvokeMetaData aroundInvoke : aroundInvokes) {
                InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                String methodName = aroundInvoke.getMethodName();
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Object.class, (String)methodName, (Class[])new Class[]{InvocationContext.class});
                builder.setAroundInvoke(methodIdentifier);
                if (aroundInvoke.getClassName() == null || aroundInvoke.getClassName().isEmpty()) {
                    String className = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)reflectionIndex, (Class)componentClass.getModuleClass(), (MethodIdentifier)methodIdentifier).getDeclaringClass().getName();
                    component.addInterceptorMethodOverride(className, builder.build());
                    continue;
                }
                component.addInterceptorMethodOverride(aroundInvoke.getClassName(), builder.build());
            }
        }
        if ((postConstructs = metaData.getPostConstructs()) != null) {
            for (LifecycleCallbackMetaData postConstruct : postConstructs) {
                InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                String methodName = postConstruct.getMethodName();
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[0]);
                builder.setPostConstruct(methodIdentifier);
                if (postConstruct.getClassName() == null || postConstruct.getClassName().isEmpty()) {
                    String className = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)reflectionIndex, (Class)componentClass.getModuleClass(), (MethodIdentifier)methodIdentifier).getDeclaringClass().getName();
                    component.addInterceptorMethodOverride(className, builder.build());
                    continue;
                }
                component.addInterceptorMethodOverride(postConstruct.getClassName(), builder.build());
            }
        }
        if ((preDestroys = metaData.getPreDestroys()) != null) {
            for (LifecycleCallbackMetaData preDestroy : preDestroys) {
                InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                String methodName = preDestroy.getMethodName();
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[0]);
                builder.setPreDestroy(methodIdentifier);
                if (preDestroy.getClassName() == null || preDestroy.getClassName().isEmpty()) {
                    String className = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)reflectionIndex, (Class)componentClass.getModuleClass(), (MethodIdentifier)methodIdentifier).getDeclaringClass().getName();
                    component.addInterceptorMethodOverride(className, builder.build());
                    continue;
                }
                component.addInterceptorMethodOverride(preDestroy.getClassName(), builder.build());
            }
        }
        if (component.isStateful()) {
            LifecycleCallbacksMetaData postActivates;
            SessionBeanMetaData sessionBeanMetadata = (SessionBeanMetaData)metaData;
            LifecycleCallbacksMetaData prePassivates = sessionBeanMetadata.getPrePassivates();
            if (prePassivates != null) {
                for (LifecycleCallbackMetaData prePassivate : prePassivates) {
                    InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                    String methodName = prePassivate.getMethodName();
                    MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[0]);
                    builder.setPrePassivate(methodIdentifier);
                    if (prePassivate.getClassName() == null || prePassivate.getClassName().isEmpty()) {
                        String className = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)reflectionIndex, (Class)componentClass.getModuleClass(), (MethodIdentifier)methodIdentifier).getDeclaringClass().getName();
                        component.addInterceptorMethodOverride(className, builder.build());
                        continue;
                    }
                    component.addInterceptorMethodOverride(prePassivate.getClassName(), builder.build());
                }
            }
            if ((postActivates = sessionBeanMetadata.getPostActivates()) != null) {
                for (LifecycleCallbackMetaData postActivate : postActivates) {
                    InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder();
                    String methodName = postActivate.getMethodName();
                    MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[0]);
                    builder.setPostActivate(methodIdentifier);
                    if (postActivate.getClassName() == null || postActivate.getClassName().isEmpty()) {
                        String className = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)reflectionIndex, (Class)componentClass.getModuleClass(), (MethodIdentifier)methodIdentifier).getDeclaringClass().getName();
                        component.addInterceptorMethodOverride(className, builder.build());
                        continue;
                    }
                    component.addInterceptorMethodOverride(postActivate.getClassName(), builder.build());
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

